/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.cloud.mongo;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import io.opentracing.Tracer;
import io.opentracing.contrib.mongo.TracingMongoClient;
import io.opentracing.contrib.spring.tracer.configuration.TracerAutoConfiguration;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.mongo.MongoAutoConfiguration;
import org.springframework.boot.autoconfigure.mongo.MongoProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@AutoConfigureBefore(value={MongoAutoConfiguration.class})
@ConditionalOnClass(value={MongoClient.class})
@ConditionalOnBean(value={Tracer.class})
@AutoConfigureAfter(value={TracerAutoConfiguration.class})
@ConditionalOnProperty(name={"opentracing.spring.cloud.mongo.enabled"}, havingValue="true", matchIfMissing=true)
public class MongoTracingAutoConfiguration
extends MongoAutoConfiguration {
    private Tracer tracer;

    public MongoTracingAutoConfiguration(@Autowired(required=false) MongoProperties properties, ObjectProvider<MongoClientOptions> options, Environment environment, Tracer tracer) {
        super(properties, options, environment);
        this.tracer = tracer;
    }

    public MongoClient mongo() {
        MongoClient mongo = super.mongo();
        return new TracingMongoClient(this.tracer, mongo.getAllAddress(), mongo.getCredentialsList(), mongo.getMongoClientOptions());
    }
}

