/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.apache.kafka.clients.FetchSessionHandler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.utils.LogContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=120L)
public class FetchSessionHandlerTest {
    private static final LogContext LOG_CONTEXT = new LogContext("[FetchSessionHandler]=");

    private static Set<TopicPartition> toSet(TopicPartition ... arr) {
        TreeSet<TopicPartition> set = new TreeSet<TopicPartition>(new Comparator<TopicPartition>(){

            @Override
            public int compare(TopicPartition o1, TopicPartition o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        set.addAll(Arrays.asList(arr));
        return set;
    }

    @Test
    public void testFindMissing() {
        TopicPartition foo0 = new TopicPartition("foo", 0);
        TopicPartition foo1 = new TopicPartition("foo", 1);
        TopicPartition bar0 = new TopicPartition("bar", 0);
        TopicPartition bar1 = new TopicPartition("bar", 1);
        TopicPartition baz0 = new TopicPartition("baz", 0);
        TopicPartition baz1 = new TopicPartition("baz", 1);
        Assertions.assertEquals(FetchSessionHandlerTest.toSet(new TopicPartition[0]), (Object)FetchSessionHandler.findMissing(FetchSessionHandlerTest.toSet(foo0), FetchSessionHandlerTest.toSet(foo0)));
        Assertions.assertEquals(FetchSessionHandlerTest.toSet(foo0), (Object)FetchSessionHandler.findMissing(FetchSessionHandlerTest.toSet(foo0), FetchSessionHandlerTest.toSet(foo1)));
        Assertions.assertEquals(FetchSessionHandlerTest.toSet(foo0, foo1), (Object)FetchSessionHandler.findMissing(FetchSessionHandlerTest.toSet(foo0, foo1), FetchSessionHandlerTest.toSet(baz0)));
        Assertions.assertEquals(FetchSessionHandlerTest.toSet(bar1, foo0, foo1), (Object)FetchSessionHandler.findMissing(FetchSessionHandlerTest.toSet(foo0, foo1, bar0, bar1), FetchSessionHandlerTest.toSet(bar0, baz0, baz1)));
        Assertions.assertEquals(FetchSessionHandlerTest.toSet(new TopicPartition[0]), (Object)FetchSessionHandler.findMissing(FetchSessionHandlerTest.toSet(foo0, foo1, bar0, bar1, baz1), FetchSessionHandlerTest.toSet(foo0, foo1, bar0, bar1, baz0, baz1)));
    }

    private static LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqMap(ReqEntry ... entries) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> map = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        for (ReqEntry entry : entries) {
            map.put(entry.part, entry.data);
        }
        return map;
    }

    private static void assertMapEquals(Map<TopicPartition, FetchRequest.PartitionData> expected, Map<TopicPartition, FetchRequest.PartitionData> actual) {
        Iterator<Map.Entry<TopicPartition, FetchRequest.PartitionData>> expectedIter = expected.entrySet().iterator();
        Iterator<Map.Entry<TopicPartition, FetchRequest.PartitionData>> actualIter = actual.entrySet().iterator();
        int i = 1;
        while (expectedIter.hasNext()) {
            Map.Entry<TopicPartition, FetchRequest.PartitionData> expectedEntry = expectedIter.next();
            if (!actualIter.hasNext()) {
                Assertions.fail((String)("Element " + i + " not found."));
            }
            Map.Entry<TopicPartition, FetchRequest.PartitionData> actuaLEntry = actualIter.next();
            Assertions.assertEquals((Object)expectedEntry.getKey(), (Object)actuaLEntry.getKey(), (String)("Element " + i + " had a different TopicPartition than expected."));
            Assertions.assertEquals((Object)expectedEntry.getValue(), (Object)actuaLEntry.getValue(), (String)("Element " + i + " had different PartitionData than expected."));
            ++i;
        }
        if (expectedIter.hasNext()) {
            Assertions.fail((String)("Unexpected element " + i + " found."));
        }
    }

    @SafeVarargs
    private static void assertMapsEqual(Map<TopicPartition, FetchRequest.PartitionData> expected, Map<TopicPartition, FetchRequest.PartitionData> ... actuals) {
        for (Map<TopicPartition, FetchRequest.PartitionData> actual : actuals) {
            FetchSessionHandlerTest.assertMapEquals(expected, actual);
        }
    }

    private static void assertListEquals(List<TopicPartition> expected, List<TopicPartition> actual) {
        for (TopicPartition expectedPart : expected) {
            if (actual.contains(expectedPart)) continue;
            Assertions.fail((String)("Failed to find expected partition " + expectedPart));
        }
        for (TopicPartition actualPart : actual) {
            if (expected.contains(actualPart)) continue;
            Assertions.fail((String)("Found unexpected partition " + actualPart));
        }
    }

    private static LinkedHashMap<TopicPartition, FetchResponseData.PartitionData> respMap(RespEntry ... entries) {
        LinkedHashMap<TopicPartition, FetchResponseData.PartitionData> map = new LinkedHashMap<TopicPartition, FetchResponseData.PartitionData>();
        for (RespEntry entry : entries) {
            map.put(entry.part, entry.data);
        }
        return map;
    }

    @Test
    public void testSessionless() {
        FetchSessionHandler handler = new FetchSessionHandler(LOG_CONTEXT, 1);
        FetchSessionHandler.Builder builder = handler.newBuilder();
        builder.add(new TopicPartition("foo", 0), new FetchRequest.PartitionData(0L, 100L, 200, Optional.empty()));
        builder.add(new TopicPartition("foo", 1), new FetchRequest.PartitionData(10L, 110L, 210, Optional.empty()));
        FetchSessionHandler.FetchRequestData data = builder.build();
        FetchSessionHandlerTest.assertMapsEqual(FetchSessionHandlerTest.reqMap(new ReqEntry("foo", 0, 0L, 100L, 200), new ReqEntry("foo", 1, 10L, 110L, 210)), data.toSend(), data.sessionPartitions());
        Assertions.assertEquals((int)0, (int)data.metadata().sessionId());
        Assertions.assertEquals((int)0, (int)data.metadata().epoch());
        FetchResponse resp = FetchResponse.of((Errors)Errors.NONE, (int)0, (int)0, FetchSessionHandlerTest.respMap(new RespEntry("foo", 0, 0L, 0L), new RespEntry("foo", 1, 0L, 0L)));
        handler.handleResponse(resp);
        FetchSessionHandler.Builder builder2 = handler.newBuilder();
        builder2.add(new TopicPartition("foo", 0), new FetchRequest.PartitionData(0L, 100L, 200, Optional.empty()));
        FetchSessionHandler.FetchRequestData data2 = builder2.build();
        Assertions.assertEquals((int)0, (int)data2.metadata().sessionId());
        Assertions.assertEquals((int)0, (int)data2.metadata().epoch());
        FetchSessionHandlerTest.assertMapsEqual(FetchSessionHandlerTest.reqMap(new ReqEntry("foo", 0, 0L, 100L, 200)), data.toSend(), data.sessionPartitions());
    }

    @Test
    public void testIncrementals() {
        FetchSessionHandler handler = new FetchSessionHandler(LOG_CONTEXT, 1);
        FetchSessionHandler.Builder builder = handler.newBuilder();
        builder.add(new TopicPartition("foo", 0), new FetchRequest.PartitionData(0L, 100L, 200, Optional.empty()));
        builder.add(new TopicPartition("foo", 1), new FetchRequest.PartitionData(10L, 110L, 210, Optional.empty()));
        FetchSessionHandler.FetchRequestData data = builder.build();
        FetchSessionHandlerTest.assertMapsEqual(FetchSessionHandlerTest.reqMap(new ReqEntry("foo", 0, 0L, 100L, 200), new ReqEntry("foo", 1, 10L, 110L, 210)), data.toSend(), data.sessionPartitions());
        Assertions.assertEquals((int)0, (int)data.metadata().sessionId());
        Assertions.assertEquals((int)0, (int)data.metadata().epoch());
        FetchResponse resp = FetchResponse.of((Errors)Errors.NONE, (int)0, (int)123, FetchSessionHandlerTest.respMap(new RespEntry("foo", 0, 10L, 20L), new RespEntry("foo", 1, 10L, 20L)));
        handler.handleResponse(resp);
        FetchSessionHandler.Builder builder2 = handler.newBuilder();
        builder2.add(new TopicPartition("foo", 0), new FetchRequest.PartitionData(0L, 100L, 200, Optional.empty()));
        builder2.add(new TopicPartition("foo", 1), new FetchRequest.PartitionData(10L, 120L, 210, Optional.empty()));
        builder2.add(new TopicPartition("bar", 0), new FetchRequest.PartitionData(20L, 200L, 200, Optional.empty()));
        FetchSessionHandler.FetchRequestData data2 = builder2.build();
        Assertions.assertFalse((boolean)data2.metadata().isFull());
        FetchSessionHandlerTest.assertMapEquals(FetchSessionHandlerTest.reqMap(new ReqEntry("foo", 0, 0L, 100L, 200), new ReqEntry("foo", 1, 10L, 120L, 210), new ReqEntry("bar", 0, 20L, 200L, 200)), data2.sessionPartitions());
        FetchSessionHandlerTest.assertMapEquals(FetchSessionHandlerTest.reqMap(new ReqEntry("bar", 0, 20L, 200L, 200), new ReqEntry("foo", 1, 10L, 120L, 210)), data2.toSend());
        FetchResponse resp2 = FetchResponse.of((Errors)Errors.NONE, (int)0, (int)123, FetchSessionHandlerTest.respMap(new RespEntry("foo", 1, 20L, 20L)));
        handler.handleResponse(resp2);
        FetchResponse resp3 = FetchResponse.of((Errors)Errors.INVALID_FETCH_SESSION_EPOCH, (int)0, (int)0, FetchSessionHandlerTest.respMap(new RespEntry[0]));
        handler.handleResponse(resp3);
        FetchSessionHandler.Builder builder4 = handler.newBuilder();
        builder4.add(new TopicPartition("foo", 0), new FetchRequest.PartitionData(0L, 100L, 200, Optional.empty()));
        builder4.add(new TopicPartition("foo", 1), new FetchRequest.PartitionData(10L, 120L, 210, Optional.empty()));
        builder4.add(new TopicPartition("bar", 0), new FetchRequest.PartitionData(20L, 200L, 200, Optional.empty()));
        FetchSessionHandler.FetchRequestData data4 = builder4.build();
        Assertions.assertTrue((boolean)data4.metadata().isFull());
        Assertions.assertEquals((int)data2.metadata().sessionId(), (int)data4.metadata().sessionId());
        Assertions.assertEquals((int)0, (int)data4.metadata().epoch());
        FetchSessionHandlerTest.assertMapsEqual(FetchSessionHandlerTest.reqMap(new ReqEntry("foo", 0, 0L, 100L, 200), new ReqEntry("foo", 1, 10L, 120L, 210), new ReqEntry("bar", 0, 20L, 200L, 200)), data4.sessionPartitions(), data4.toSend());
    }

    @Test
    public void testDoubleBuild() {
        FetchSessionHandler handler = new FetchSessionHandler(LOG_CONTEXT, 1);
        FetchSessionHandler.Builder builder = handler.newBuilder();
        builder.add(new TopicPartition("foo", 0), new FetchRequest.PartitionData(0L, 100L, 200, Optional.empty()));
        builder.build();
        try {
            builder.build();
            Assertions.fail((String)"Expected calling build twice to fail.");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Test
    public void testIncrementalPartitionRemoval() {
        FetchSessionHandler handler = new FetchSessionHandler(LOG_CONTEXT, 1);
        FetchSessionHandler.Builder builder = handler.newBuilder();
        builder.add(new TopicPartition("foo", 0), new FetchRequest.PartitionData(0L, 100L, 200, Optional.empty()));
        builder.add(new TopicPartition("foo", 1), new FetchRequest.PartitionData(10L, 110L, 210, Optional.empty()));
        builder.add(new TopicPartition("bar", 0), new FetchRequest.PartitionData(20L, 120L, 220, Optional.empty()));
        FetchSessionHandler.FetchRequestData data = builder.build();
        FetchSessionHandlerTest.assertMapsEqual(FetchSessionHandlerTest.reqMap(new ReqEntry("foo", 0, 0L, 100L, 200), new ReqEntry("foo", 1, 10L, 110L, 210), new ReqEntry("bar", 0, 20L, 120L, 220)), data.toSend(), data.sessionPartitions());
        Assertions.assertTrue((boolean)data.metadata().isFull());
        FetchResponse resp = FetchResponse.of((Errors)Errors.NONE, (int)0, (int)123, FetchSessionHandlerTest.respMap(new RespEntry("foo", 0, 10L, 20L), new RespEntry("foo", 1, 10L, 20L), new RespEntry("bar", 0, 10L, 20L)));
        handler.handleResponse(resp);
        FetchSessionHandler.Builder builder2 = handler.newBuilder();
        builder2.add(new TopicPartition("foo", 1), new FetchRequest.PartitionData(10L, 110L, 210, Optional.empty()));
        FetchSessionHandler.FetchRequestData data2 = builder2.build();
        Assertions.assertFalse((boolean)data2.metadata().isFull());
        Assertions.assertEquals((int)123, (int)data2.metadata().sessionId());
        Assertions.assertEquals((int)1, (int)data2.metadata().epoch());
        FetchSessionHandlerTest.assertMapEquals(FetchSessionHandlerTest.reqMap(new ReqEntry("foo", 1, 10L, 110L, 210)), data2.sessionPartitions());
        FetchSessionHandlerTest.assertMapEquals(FetchSessionHandlerTest.reqMap(new ReqEntry[0]), data2.toSend());
        ArrayList<TopicPartition> expectedToForget2 = new ArrayList<TopicPartition>();
        expectedToForget2.add(new TopicPartition("foo", 0));
        expectedToForget2.add(new TopicPartition("bar", 0));
        FetchSessionHandlerTest.assertListEquals(expectedToForget2, data2.toForget());
        FetchResponse resp2 = FetchResponse.of((Errors)Errors.FETCH_SESSION_ID_NOT_FOUND, (int)0, (int)0, FetchSessionHandlerTest.respMap(new RespEntry[0]));
        handler.handleResponse(resp2);
        FetchSessionHandler.Builder builder3 = handler.newBuilder();
        builder3.add(new TopicPartition("foo", 0), new FetchRequest.PartitionData(0L, 100L, 200, Optional.empty()));
        FetchSessionHandler.FetchRequestData data3 = builder3.build();
        Assertions.assertTrue((boolean)data3.metadata().isFull());
        Assertions.assertEquals((int)0, (int)data3.metadata().sessionId());
        Assertions.assertEquals((int)0, (int)data3.metadata().epoch());
        FetchSessionHandlerTest.assertMapsEqual(FetchSessionHandlerTest.reqMap(new ReqEntry("foo", 0, 0L, 100L, 200)), data3.sessionPartitions(), data3.toSend());
    }

    @Test
    public void testVerifyFullFetchResponsePartitions() throws Exception {
        FetchSessionHandler handler = new FetchSessionHandler(LOG_CONTEXT, 1);
        String issue = handler.verifyFullFetchResponsePartitions(FetchResponse.of((Errors)Errors.NONE, (int)0, (int)0, FetchSessionHandlerTest.respMap(new RespEntry("foo", 0, 10L, 20L), new RespEntry("foo", 1, 10L, 20L), new RespEntry("bar", 0, 10L, 20L))));
        Assertions.assertTrue((boolean)issue.contains("extra"));
        Assertions.assertFalse((boolean)issue.contains("omitted"));
        FetchSessionHandler.Builder builder = handler.newBuilder();
        builder.add(new TopicPartition("foo", 0), new FetchRequest.PartitionData(0L, 100L, 200, Optional.empty()));
        builder.add(new TopicPartition("foo", 1), new FetchRequest.PartitionData(10L, 110L, 210, Optional.empty()));
        builder.add(new TopicPartition("bar", 0), new FetchRequest.PartitionData(20L, 120L, 220, Optional.empty()));
        builder.build();
        String issue2 = handler.verifyFullFetchResponsePartitions(FetchResponse.of((Errors)Errors.NONE, (int)0, (int)0, FetchSessionHandlerTest.respMap(new RespEntry("foo", 0, 10L, 20L), new RespEntry("foo", 1, 10L, 20L), new RespEntry("bar", 0, 10L, 20L))));
        Assertions.assertTrue((issue2 == null ? 1 : 0) != 0);
        String issue3 = handler.verifyFullFetchResponsePartitions(FetchResponse.of((Errors)Errors.NONE, (int)0, (int)0, FetchSessionHandlerTest.respMap(new RespEntry("foo", 0, 10L, 20L), new RespEntry("foo", 1, 10L, 20L))));
        Assertions.assertFalse((boolean)issue3.contains("extra"));
        Assertions.assertTrue((boolean)issue3.contains("omitted"));
    }

    private static final class RespEntry {
        final TopicPartition part;
        final FetchResponseData.PartitionData data;

        RespEntry(String topic, int partition, long highWatermark, long lastStableOffset) {
            this.part = new TopicPartition(topic, partition);
            this.data = new FetchResponseData.PartitionData().setPartitionIndex(partition).setHighWatermark(highWatermark).setLastStableOffset(lastStableOffset).setLogStartOffset(0L);
        }
    }

    private static final class ReqEntry {
        final TopicPartition part;
        final FetchRequest.PartitionData data;

        ReqEntry(String topic, int partition, long fetchOffset, long logStartOffset, int maxBytes) {
            this.part = new TopicPartition(topic, partition);
            this.data = new FetchRequest.PartitionData(fetchOffset, logStartOffset, maxBytes, Optional.empty());
        }
    }
}

