/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.queryserver.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.avatica.remote.Driver;
import org.apache.calcite.avatica.remote.LocalService;
import org.apache.calcite.avatica.remote.Service;
import org.apache.calcite.avatica.server.DoAsRemoteUserCallback;
import org.apache.calcite.avatica.server.HttpQueryStringParameterRemoteUserExtractor;
import org.apache.calcite.avatica.server.HttpRequestRemoteUserExtractor;
import org.apache.calcite.avatica.server.HttpServer;
import org.apache.calcite.avatica.server.RemoteUserExtractionException;
import org.apache.calcite.avatica.server.RemoteUserExtractor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.util.Strings;
import org.apache.hadoop.net.DNS;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.phoenix.loadbalancer.service.LoadBalanceZookeeperConf;
import org.apache.phoenix.query.QueryServicesOptions;
import org.apache.phoenix.queryserver.register.Registry;
import org.apache.phoenix.queryserver.server.PhoenixMetaFactory;
import org.apache.phoenix.queryserver.server.PhoenixMetaFactoryImpl;
import org.apache.phoenix.queryserver.server.RemoteUserExtractorFactory;
import org.apache.phoenix.util.InstanceResolver;

public final class QueryServer
extends Configured
implements Tool,
Runnable {
    protected static final Log LOG = LogFactory.getLog(QueryServer.class);
    private final String[] argv;
    private final CountDownLatch runningLatch = new CountDownLatch(1);
    private HttpServer server = null;
    private int retCode = 0;
    private Throwable t = null;
    private Registry registry;
    private static final RemoteUserExtractorFactory DEFAULT_USER_EXTRACTOR = new RemoteUserExtractorFactory.RemoteUserExtractorFactoryImpl();

    public static void logJVMInfo() {
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        if (runtime != null) {
            LOG.info((Object)("vmName=" + runtime.getVmName() + ", vmVendor=" + runtime.getVmVendor() + ", vmVersion=" + runtime.getVmVersion()));
            LOG.info((Object)("vmInputArguments=" + runtime.getInputArguments()));
        }
    }

    public static void logProcessInfo(Configuration conf) {
        if (conf == null || !conf.getBoolean("phoenix.queryserver.envvars.logging.disabled", false)) {
            String[] confSkipWords;
            HashSet<String> skipWords = new HashSet<String>(QueryServicesOptions.DEFAULT_QUERY_SERVER_SKIP_WORDS);
            if (conf != null && (confSkipWords = conf.getStrings("phoenix.queryserver.envvars.logging.skipwords")) != null) {
                skipWords.addAll(Arrays.asList(confSkipWords));
            }
            block0: for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
                String key = entry.getKey().toLowerCase();
                String value = entry.getValue().toLowerCase();
                for (String skipWord : skipWords) {
                    if (!key.contains(skipWord) && !value.contains(skipWord)) continue;
                    continue block0;
                }
                LOG.info((Object)("env:" + entry));
            }
        }
        QueryServer.logJVMInfo();
    }

    public QueryServer() {
        this(null, null);
    }

    public QueryServer(String[] argv, Configuration conf) {
        this.argv = argv;
        this.setConf(conf);
    }

    @VisibleForTesting
    public int getPort() {
        if (this.server == null) {
            return -1;
        }
        return this.server.getPort();
    }

    @VisibleForTesting
    public int getRetCode() {
        return this.retCode;
    }

    @VisibleForTesting
    public Throwable getThrowable() {
        return this.t;
    }

    public void awaitRunning() throws InterruptedException {
        this.runningLatch.await();
    }

    public void awaitRunning(long timeout, TimeUnit unit) throws InterruptedException {
        this.runningLatch.await(timeout, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] args) throws Exception {
        QueryServer.logProcessInfo(this.getConf());
        boolean loadBalancerEnabled = this.getConf().getBoolean("phoenix.queryserver.loadbalancer.enabled", false);
        try {
            String hostname;
            boolean isKerberos = "kerberos".equalsIgnoreCase(this.getConf().get("hbase.security.authentication"));
            boolean disableSpnego = this.getConf().getBoolean("phoenix.queryserver.spnego.auth.disabled", false);
            boolean disableLogin = this.getConf().getBoolean("phoenix.queryserver.disable.kerberos.login", false);
            if (isKerberos && !disableLogin) {
                hostname = Strings.domainNamePointerToHostName((String)DNS.getDefaultHost((String)this.getConf().get("phoenix.queryserver.dns.interface", "default"), (String)this.getConf().get("phoenix.queryserver.dns.nameserver", "default")));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Login to " + hostname + " using " + this.getConf().get("phoenix.queryserver.keytab.file") + " and principal " + this.getConf().get("phoenix.queryserver.kerberos.principal") + "."));
                }
                SecurityUtil.login((Configuration)this.getConf(), (String)"phoenix.queryserver.keytab.file", (String)"phoenix.queryserver.kerberos.principal", (String)hostname);
                LOG.info((Object)"Login successful.");
            } else {
                hostname = InetAddress.getLocalHost().getHostName();
                LOG.info((Object)(" Kerberos is off and hostname is : " + hostname));
            }
            Class factoryClass = this.getConf().getClass("phoenix.queryserver.metafactory.class", PhoenixMetaFactoryImpl.class, PhoenixMetaFactory.class);
            int port = this.getConf().getInt("phoenix.queryserver.http.port", 8765);
            LOG.debug((Object)("Listening on port " + port));
            PhoenixMetaFactory factory = (PhoenixMetaFactory)factoryClass.getDeclaredConstructor(Configuration.class).newInstance(this.getConf());
            Meta meta = factory.create(Arrays.asList(args));
            LocalService service = new LocalService(meta);
            HttpServer.Builder builder = new HttpServer.Builder().withPort(port).withHandler((Service)service, this.getSerialization(this.getConf()));
            if (isKerberos) {
                this.configureClientAuthentication(builder, disableSpnego);
            }
            this.setRemoteUserExtractorIfNecessary(builder, this.getConf());
            this.server = builder.build();
            this.server.start();
            if (loadBalancerEnabled) {
                this.registerToServiceProvider(hostname);
            }
            this.runningLatch.countDown();
            this.server.join();
            int n = 0;
            return n;
        }
        catch (Throwable t) {
            LOG.fatal((Object)"Unrecoverable service error. Shutting down.", t);
            this.t = t;
            int n = -1;
            return n;
        }
        finally {
            if (loadBalancerEnabled) {
                this.unRegister();
            }
        }
    }

    @VisibleForTesting
    void configureClientAuthentication(HttpServer.Builder builder, boolean disableSpnego) throws IOException {
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        LOG.debug((Object)("Current user is " + ugi));
        if (!ugi.hasKerberosCredentials()) {
            ugi = UserGroupInformation.getLoginUser();
            LOG.debug((Object)("Current user does not have Kerberos credentials, using instead " + ugi));
        }
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)this.getConf());
        builder.withImpersonation((DoAsRemoteUserCallback)new PhoenixDoAsCallback(ugi, this.getConf()));
        if (!disableSpnego) {
            String keytabPath = this.getConf().get("phoenix.queryserver.keytab.file");
            File keytab = new File(keytabPath);
            String httpKeytabPath = this.getConf().get("phoenix.queryserver.http.keytab.file", null);
            String httpPrincipal = this.getConf().get("phoenix.queryserver.http.kerberos.principal", null);
            if (httpPrincipal == null) {
                httpPrincipal = this.getConf().get("phoenix.queryserver.kerberos.http.principal", null);
            }
            File httpKeytab = null;
            if (null != httpKeytabPath) {
                httpKeytab = new File(httpKeytabPath);
            }
            String realmsString = this.getConf().get("phoenix.queryserver.kerberos.allowed.realms", null);
            String[] additionalAllowedRealms = null;
            if (null != realmsString) {
                additionalAllowedRealms = StringUtils.split((String)realmsString, (char)',');
            }
            if (null != httpKeytabPath && null != httpPrincipal) {
                builder.withSpnego(httpPrincipal, additionalAllowedRealms).withAutomaticLogin(httpKeytab);
            } else {
                builder.withSpnego(ugi.getUserName(), additionalAllowedRealms).withAutomaticLogin(keytab);
            }
        }
    }

    public synchronized void stop() {
        this.server.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerToServiceProvider(String hostName) {
        boolean success = true;
        try {
            LoadBalanceZookeeperConf loadBalanceConfiguration = this.getLoadBalanceConfiguration();
            Preconditions.checkNotNull((Object)loadBalanceConfiguration);
            this.registry = this.getRegistry();
            Preconditions.checkNotNull((Object)this.registry);
            String zkConnectString = loadBalanceConfiguration.getZkConnectString();
            this.registry.registerServer(loadBalanceConfiguration, this.getPort(), zkConnectString, hostName);
        }
        catch (Throwable ex) {
            LOG.debug((Object)"Caught an error trying to register with the load balancer", ex);
            success = false;
            return success;
        }
        finally {
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoadBalanceZookeeperConf getLoadBalanceConfiguration() {
        ServiceLoader<LoadBalanceZookeeperConf> serviceLocator = ServiceLoader.load(LoadBalanceZookeeperConf.class);
        LoadBalanceZookeeperConf zookeeperConfig = null;
        try {
            if (serviceLocator.iterator().hasNext()) {
                zookeeperConfig = serviceLocator.iterator().next();
                return zookeeperConfig;
            }
        }
        catch (ServiceConfigurationError ex) {
            LOG.debug((Object)"Unable to locate the service provider for load balancer configuration", (Throwable)ex);
        }
        finally {
            return zookeeperConfig;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Registry getRegistry() {
        ServiceLoader<Registry> serviceLocator = ServiceLoader.load(Registry.class);
        Registry registry = null;
        try {
            if (serviceLocator.iterator().hasNext()) {
                registry = serviceLocator.iterator().next();
                return registry;
            }
        }
        catch (ServiceConfigurationError ex) {
            LOG.debug((Object)"Unable to locate the zookeeper registry for the load balancer", (Throwable)ex);
        }
        finally {
            return registry;
        }
    }

    public boolean unRegister() {
        boolean success = true;
        try {
            this.registry.unRegisterServer();
        }
        catch (Throwable ex) {
            LOG.debug((Object)"Caught an error while de-registering the query server from the load balancer", ex);
            success = false;
            return success;
        }
        finally {
            return success;
        }
    }

    Driver.Serialization getSerialization(Configuration conf) {
        Driver.Serialization serialization;
        String serializationName = conf.get("phoenix.queryserver.serialization", "PROTOBUF");
        try {
            serialization = Driver.Serialization.valueOf((String)serializationName);
        }
        catch (Exception e) {
            LOG.error((Object)("Unknown message serialization type for " + serializationName));
            throw e;
        }
        return serialization;
    }

    @Override
    public void run() {
        try {
            this.retCode = this.run(this.argv);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @VisibleForTesting
    public void setRemoteUserExtractorIfNecessary(HttpServer.Builder builder, Configuration conf) {
        if (conf.getBoolean("phoenix.queryserver.withRemoteUserExtractor", false)) {
            builder.withRemoteUserExtractor(this.createRemoteUserExtractor(conf));
        }
    }

    @VisibleForTesting
    RemoteUserExtractor createRemoteUserExtractor(Configuration conf) {
        RemoteUserExtractorFactory factory = (RemoteUserExtractorFactory)InstanceResolver.getSingleton(RemoteUserExtractorFactory.class, (Object)DEFAULT_USER_EXTRACTOR);
        return factory.createRemoteUserExtractor(conf);
    }

    public static void main(String[] argv) throws Exception {
        int ret = ToolRunner.run((Configuration)HBaseConfiguration.create(), (Tool)new QueryServer(), (String[])argv);
        System.exit(ret);
    }

    static class UgiCacheLoader
    extends CacheLoader<String, UserGroupInformation> {
        private final UserGroupInformation serverUgi;

        public UgiCacheLoader(UserGroupInformation serverUgi) {
            this.serverUgi = Objects.requireNonNull(serverUgi);
        }

        public UserGroupInformation load(String remoteUserName) throws Exception {
            return UserGroupInformation.createProxyUser((String)remoteUserName, (UserGroupInformation)this.serverUgi);
        }
    }

    static class PhoenixDoAsCallback
    implements DoAsRemoteUserCallback {
        private final UserGroupInformation serverUgi;
        private final LoadingCache<String, UserGroupInformation> ugiCache;

        public PhoenixDoAsCallback(UserGroupInformation serverUgi, Configuration conf) {
            this.serverUgi = Objects.requireNonNull(serverUgi);
            this.ugiCache = CacheBuilder.newBuilder().initialCapacity(conf.getInt("phoenix.queryserver.ugi.cache.initial.size", 100)).concurrencyLevel(conf.getInt("phoenix.queryserver.ugi.cache.concurrency", 10)).maximumSize(conf.getLong("phoenix.queryserver.ugi.cache.max.size", 1000L)).build((CacheLoader)new UgiCacheLoader(this.serverUgi));
        }

        public <T> T doAsRemoteUser(String remoteUserName, String remoteAddress, final Callable<T> action) throws Exception {
            UserGroupInformation proxyUser = this.createProxyUser(remoteUserName);
            return (T)proxyUser.doAs(new PrivilegedExceptionAction<T>(){

                @Override
                public T run() throws Exception {
                    return action.call();
                }
            });
        }

        @VisibleForTesting
        UserGroupInformation createProxyUser(String remoteUserName) throws ExecutionException {
            return (UserGroupInformation)this.ugiCache.get((Object)remoteUserName);
        }

        @VisibleForTesting
        LoadingCache<String, UserGroupInformation> getCache() {
            return this.ugiCache;
        }
    }

    static class PhoenixRemoteUserExtractor
    implements RemoteUserExtractor {
        private final HttpQueryStringParameterRemoteUserExtractor paramRemoteUserExtractor;
        private final HttpRequestRemoteUserExtractor requestRemoteUserExtractor = new HttpRequestRemoteUserExtractor();
        private final String userExtractParam;

        public PhoenixRemoteUserExtractor(Configuration conf) {
            this.userExtractParam = conf.get("phoenix.queryserver.remoteUserExtractor.param", "doAs");
            this.paramRemoteUserExtractor = new HttpQueryStringParameterRemoteUserExtractor(this.userExtractParam);
        }

        public String extract(HttpServletRequest request) throws RemoteUserExtractionException {
            if (request.getParameter(this.userExtractParam) != null) {
                String extractedUser = this.paramRemoteUserExtractor.extract(request);
                UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)request.getRemoteUser());
                UserGroupInformation proxyUser = UserGroupInformation.createProxyUser((String)extractedUser, (UserGroupInformation)ugi);
                try {
                    ProxyUsers.authorize((UserGroupInformation)proxyUser, (String)request.getRemoteAddr());
                    return extractedUser;
                }
                catch (AuthorizationException e) {
                    throw new RemoteUserExtractionException(e.getMessage(), (Throwable)e);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("The parameter (" + this.userExtractParam + ") used to extract the remote user doesn't exist in the request."));
            }
            return this.requestRemoteUserExtractor.extract(request);
        }
    }
}

