/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.configuration.configmap;

import io.kubernetes.client.openapi.models.V1ConfigMap;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.skywalking.oap.server.configuration.api.ConfigTable;
import org.apache.skywalking.oap.server.configuration.api.ConfigWatcherRegister;
import org.apache.skywalking.oap.server.configuration.configmap.ConfigmapConfigurationSettings;
import org.apache.skywalking.oap.server.configuration.configmap.ConfigurationConfigmapInformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigmapConfigurationWatcherRegister
extends ConfigWatcherRegister {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfigmapConfigurationWatcherRegister.class);
    private final ConfigurationConfigmapInformer informer;

    public ConfigmapConfigurationWatcherRegister(ConfigmapConfigurationSettings settings, ConfigurationConfigmapInformer informer) {
        super((long)settings.getPeriod().intValue());
        this.informer = informer;
    }

    public Optional<ConfigTable> readConfig(Set<String> keys) {
        ConfigTable configTable = new ConfigTable();
        Optional<V1ConfigMap> v1ConfigMap = this.informer.configMap();
        for (String name : keys) {
            String value = v1ConfigMap.map(V1ConfigMap::getData).map(data -> (String)data.get(name)).orElse(null);
            if (log.isDebugEnabled()) {
                log.debug("read config: name:{} ,value:{}", (Object)name, (Object)value);
            }
            if (!Objects.nonNull(value)) continue;
            configTable.add(new ConfigTable.ConfigItem(name, value));
        }
        return Optional.of(configTable);
    }
}

