/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.configuration.configmap;

import io.kubernetes.client.informer.SharedIndexInformer;
import io.kubernetes.client.informer.SharedInformerFactory;
import io.kubernetes.client.informer.cache.Lister;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1ConfigMap;
import io.kubernetes.client.openapi.models.V1ConfigMapList;
import io.kubernetes.client.util.Config;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.skywalking.oap.server.configuration.configmap.ConfigmapConfigurationSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationConfigmapInformer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfigurationConfigmapInformer.class);
    private Lister<V1ConfigMap> configMapLister;
    private SharedInformerFactory factory;
    private final ExecutorService executorService = Executors.newSingleThreadExecutor(r -> {
        Thread thread = new Thread(r, "SKYWALKING_KUBERNETES_CONFIGURATION_INFORMER");
        thread.setDaemon(true);
        return thread;
    });

    public ConfigurationConfigmapInformer(ConfigmapConfigurationSettings settings) {
        try {
            this.doStartConfigMapInformer(settings);
            this.doAddShutdownHook();
        }
        catch (IOException e) {
            log.error("cannot connect with api server in kubernetes", (Throwable)e);
        }
    }

    private void doAddShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (Objects.nonNull(this.factory)) {
                this.factory.stopAllRegisteredInformers();
            }
        }));
    }

    private void doStartConfigMapInformer(ConfigmapConfigurationSettings settings) throws IOException {
        ApiClient apiClient = Config.defaultClient();
        apiClient.setHttpClient(apiClient.getHttpClient().newBuilder().readTimeout(0L, TimeUnit.SECONDS).build());
        Configuration.setDefaultApiClient((ApiClient)apiClient);
        CoreV1Api coreV1Api = new CoreV1Api(apiClient);
        this.factory = new SharedInformerFactory(this.executorService);
        SharedIndexInformer configMapSharedIndexInformer = this.factory.sharedIndexInformerFor(params -> coreV1Api.listNamespacedConfigMapCall(settings.getNamespace(), null, null, null, null, settings.getLabelSelector(), Integer.valueOf(1), params.resourceVersion, null, params.timeoutSeconds, params.watch, null), V1ConfigMap.class, V1ConfigMapList.class);
        this.factory.startAllRegisteredInformers();
        this.configMapLister = new Lister(configMapSharedIndexInformer.getIndexer());
    }

    public Optional<V1ConfigMap> configMap() {
        return Optional.ofNullable(this.configMapLister.list().size() == 1 ? (V1ConfigMap)this.configMapLister.list().get(0) : null);
    }
}

