/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.analyzer.event.listener;

import com.google.gson.Gson;
import lombok.Generated;
import org.apache.skywalking.apm.network.event.v3.Event;
import org.apache.skywalking.apm.network.event.v3.Source;
import org.apache.skywalking.oap.server.analyzer.event.listener.EventAnalyzerListener;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsStreamProcessor;
import org.apache.skywalking.oap.server.core.config.NamingControl;
import org.apache.skywalking.oap.server.library.module.ModuleManager;

public class EventRecordAnalyzerListener
implements EventAnalyzerListener {
    private static final Gson GSON = new Gson();
    private final NamingControl namingControl;
    private final org.apache.skywalking.oap.server.core.event.Event event = new org.apache.skywalking.oap.server.core.event.Event();

    @Override
    public void build() {
        MetricsStreamProcessor.getInstance().in((Metrics)this.event);
    }

    @Override
    public void parse(Event e) {
        this.event.setUuid(e.getUuid());
        if (e.hasSource()) {
            Source source = e.getSource();
            this.event.setService(this.namingControl.formatServiceName(source.getService()));
            this.event.setServiceInstance(this.namingControl.formatInstanceName(source.getServiceInstance()));
            this.event.setEndpoint(this.namingControl.formatEndpointName(source.getService(), source.getEndpoint()));
        }
        this.event.setName(e.getName());
        this.event.setType(e.getType().name());
        this.event.setMessage(e.getMessage());
        if (e.getParametersCount() > 0) {
            this.event.setParameters(GSON.toJson((Object)e.getParametersMap()));
        }
        this.event.setStartTime(e.getStartTime());
        this.event.setEndTime(e.getEndTime());
        if (e.getStartTime() > 0L) {
            this.event.setTimeBucket(TimeBucket.getMinuteTimeBucket((long)e.getStartTime()));
        } else if (e.getEndTime() > 0L) {
            this.event.setTimeBucket(TimeBucket.getMinuteTimeBucket((long)e.getEndTime()));
        }
    }

    @Generated
    public EventRecordAnalyzerListener(NamingControl namingControl) {
        this.namingControl = namingControl;
    }

    public static class Factory
    implements EventAnalyzerListener.Factory {
        private final NamingControl namingControl;

        public Factory(ModuleManager moduleManager) {
            this.namingControl = (NamingControl)moduleManager.find("core").provider().getService(NamingControl.class);
        }

        @Override
        public EventAnalyzerListener create(ModuleManager moduleManager) {
            return new EventRecordAnalyzerListener(this.namingControl);
        }
    }
}

