/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;

public class ResourceUtils {
    public static Reader read(String fileName) throws FileNotFoundException {
        return new InputStreamReader(ResourceUtils.readToStream(fileName));
    }

    public static InputStream readToStream(String fileName) throws FileNotFoundException {
        URL url = ResourceUtils.class.getClassLoader().getResource(fileName);
        if (url == null) {
            throw new FileNotFoundException("file not found: " + fileName);
        }
        return ResourceUtils.class.getClassLoader().getResourceAsStream(fileName);
    }

    public static File[] getPathFiles(String path) throws FileNotFoundException {
        URL url = ResourceUtils.class.getClassLoader().getResource(path);
        if (url == null) {
            throw new FileNotFoundException("path not found: " + path);
        }
        return (File[])Arrays.stream((Object[])Objects.requireNonNull(new File(url.getPath()).listFiles(), "No files in " + path)).filter(File::isFile).toArray(File[]::new);
    }

    public static File[] getPathFiles(String parentPath, String[] fileNames) throws FileNotFoundException {
        URL url = ResourceUtils.class.getClassLoader().getResource(parentPath);
        if (url == null) {
            throw new FileNotFoundException("path not found: " + parentPath);
        }
        HashSet<String> nameSet = new HashSet<String>(Arrays.asList(fileNames));
        File[] listFiles = Objects.requireNonNull(new File(url.getPath()).listFiles((dir, name) -> nameSet.contains(name)), "No files in " + parentPath);
        if (listFiles.length == 0) {
            throw new FileNotFoundException("files not found:" + nameSet);
        }
        return listFiles;
    }
}

