/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.register.provider.handler.v8.grpc;

import com.google.gson.JsonObject;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.apache.skywalking.apm.network.common.v3.Commands;
import org.apache.skywalking.apm.network.management.v3.InstancePingPkg;
import org.apache.skywalking.apm.network.management.v3.InstanceProperties;
import org.apache.skywalking.apm.network.management.v3.ManagementServiceGrpc;
import org.apache.skywalking.oap.server.core.analysis.DownSampling;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.NodeType;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.config.NamingControl;
import org.apache.skywalking.oap.server.core.source.ServiceInstanceUpdate;
import org.apache.skywalking.oap.server.core.source.ServiceMeta;
import org.apache.skywalking.oap.server.core.source.Source;
import org.apache.skywalking.oap.server.core.source.SourceReceiver;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.server.grpc.GRPCHandler;

public class ManagementServiceHandler
extends ManagementServiceGrpc.ManagementServiceImplBase
implements GRPCHandler {
    private final SourceReceiver sourceReceiver;
    private final NamingControl namingControl;

    public ManagementServiceHandler(ModuleManager moduleManager) {
        this.sourceReceiver = (SourceReceiver)moduleManager.find("core").provider().getService(SourceReceiver.class);
        this.namingControl = (NamingControl)moduleManager.find("core").provider().getService(NamingControl.class);
    }

    public void reportInstanceProperties(InstanceProperties request, StreamObserver<Commands> responseObserver) {
        ServiceInstanceUpdate serviceInstanceUpdate = new ServiceInstanceUpdate();
        String serviceName = this.namingControl.formatServiceName(request.getService());
        String instanceName = this.namingControl.formatInstanceName(request.getServiceInstance());
        serviceInstanceUpdate.setServiceId(IDManager.ServiceID.buildId((String)serviceName, (NodeType)NodeType.Normal));
        serviceInstanceUpdate.setName(instanceName);
        JsonObject properties = new JsonObject();
        ArrayList ipv4List = new ArrayList();
        request.getPropertiesList().forEach(prop -> {
            if ("ipv4".equals(prop.getKey())) {
                ipv4List.add(prop.getValue());
            } else {
                properties.addProperty(prop.getKey(), prop.getValue());
            }
        });
        properties.addProperty("ipv4s", ipv4List.stream().collect(Collectors.joining(",")));
        serviceInstanceUpdate.setProperties(properties);
        serviceInstanceUpdate.setTimeBucket(TimeBucket.getTimeBucket((long)System.currentTimeMillis(), (DownSampling)DownSampling.Minute));
        this.sourceReceiver.receive((Source)serviceInstanceUpdate);
        responseObserver.onNext((Object)Commands.newBuilder().build());
        responseObserver.onCompleted();
    }

    public void keepAlive(InstancePingPkg request, StreamObserver<Commands> responseObserver) {
        long timeBucket = TimeBucket.getTimeBucket((long)System.currentTimeMillis(), (DownSampling)DownSampling.Minute);
        String serviceName = this.namingControl.formatServiceName(request.getService());
        String instanceName = this.namingControl.formatInstanceName(request.getServiceInstance());
        ServiceInstanceUpdate serviceInstanceUpdate = new ServiceInstanceUpdate();
        serviceInstanceUpdate.setServiceId(IDManager.ServiceID.buildId((String)serviceName, (NodeType)NodeType.Normal));
        serviceInstanceUpdate.setName(instanceName);
        serviceInstanceUpdate.setTimeBucket(timeBucket);
        this.sourceReceiver.receive((Source)serviceInstanceUpdate);
        ServiceMeta serviceMeta = new ServiceMeta();
        serviceMeta.setName(serviceName);
        serviceMeta.setNodeType(NodeType.Normal);
        serviceMeta.setTimeBucket(timeBucket);
        this.sourceReceiver.receive((Source)serviceMeta);
        responseObserver.onNext((Object)Commands.newBuilder().build());
        responseObserver.onCompleted();
    }
}

