/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.register.provider.handler.v8.rest;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.protobuf.Message;
import java.io.IOException;
import java.util.ArrayList;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.skywalking.apm.network.common.v3.Commands;
import org.apache.skywalking.apm.network.management.v3.InstanceProperties;
import org.apache.skywalking.oap.server.core.analysis.DownSampling;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.NodeType;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.config.NamingControl;
import org.apache.skywalking.oap.server.core.source.ServiceInstanceUpdate;
import org.apache.skywalking.oap.server.core.source.Source;
import org.apache.skywalking.oap.server.core.source.SourceReceiver;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.server.jetty.ArgumentsParseException;
import org.apache.skywalking.oap.server.library.server.jetty.JettyJsonHandler;
import org.apache.skywalking.oap.server.library.util.ProtoBufJsonUtils;

public class ManagementServiceReportPropertiesHandler
extends JettyJsonHandler {
    private final SourceReceiver sourceReceiver;
    private final NamingControl namingControl;
    private final Gson gson = new Gson();

    public ManagementServiceReportPropertiesHandler(ModuleManager moduleManager) {
        this.sourceReceiver = (SourceReceiver)moduleManager.find("core").provider().getService(SourceReceiver.class);
        this.namingControl = (NamingControl)moduleManager.find("core").provider().getService(NamingControl.class);
    }

    protected JsonElement doPost(HttpServletRequest req) throws ArgumentsParseException, IOException {
        InstanceProperties.Builder request = InstanceProperties.newBuilder();
        ProtoBufJsonUtils.fromJSON((String)this.getJsonBody(req), (Message.Builder)request);
        String serviceName = this.namingControl.formatServiceName(request.getService());
        String instanceName = this.namingControl.formatInstanceName(request.getServiceInstance());
        ServiceInstanceUpdate serviceInstanceUpdate = new ServiceInstanceUpdate();
        serviceInstanceUpdate.setServiceId(IDManager.ServiceID.buildId((String)serviceName, (NodeType)NodeType.Normal));
        serviceInstanceUpdate.setName(instanceName);
        JsonObject properties = new JsonObject();
        ArrayList ipv4List = new ArrayList();
        request.getPropertiesList().forEach(prop -> {
            if ("ipv4".equals(prop.getKey())) {
                ipv4List.add(prop.getValue());
            } else {
                properties.addProperty(prop.getKey(), prop.getValue());
            }
        });
        properties.addProperty("ipv4s", ipv4List.stream().collect(Collectors.joining(",")));
        serviceInstanceUpdate.setProperties(properties);
        serviceInstanceUpdate.setTimeBucket(TimeBucket.getTimeBucket((long)System.currentTimeMillis(), (DownSampling)DownSampling.Minute));
        this.sourceReceiver.receive((Source)serviceInstanceUpdate);
        return (JsonElement)this.gson.fromJson(ProtoBufJsonUtils.toJSON((Message)Commands.newBuilder().build()), JsonElement.class);
    }

    public String pathSpec() {
        return "/v3/management/reportProperties";
    }
}

