/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.RoutingRule;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.noggit.JSONUtil;
import org.noggit.JSONWriter;

public class Slice
extends ZkNodeProps
implements Iterable<Replica> {
    public static final String REPLICAS = "replicas";
    public static final String RANGE = "range";
    public static final String LEADER = "leader";
    public static final String PARENT = "parent";
    private final String name;
    private final DocRouter.Range range;
    private final Integer replicationFactor;
    private final Map<String, Replica> replicas;
    private final Replica leader;
    private final State state;
    private final String parent;
    private final Map<String, RoutingRule> routingRules;

    public static Map<String, Slice> loadAllFromMap(Map<String, Object> genericSlices) {
        if (genericSlices == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Slice> result = new LinkedHashMap<String, Slice>(genericSlices.size());
        for (Map.Entry<String, Object> entry : genericSlices.entrySet()) {
            String name = entry.getKey();
            Object val = entry.getValue();
            if (val instanceof Slice) {
                result.put(name, (Slice)val);
                continue;
            }
            if (!(val instanceof Map)) continue;
            result.put(name, new Slice(name, null, (Map)val));
        }
        return result;
    }

    @Override
    public Iterator<Replica> iterator() {
        return this.replicas.values().iterator();
    }

    public Slice(String name, Map<String, Replica> replicas, Map<String, Object> props) {
        super(props == null ? new LinkedHashMap<String, Object>(2) : new LinkedHashMap<String, Object>(props));
        this.name = name;
        Object rangeObj = this.propMap.get(RANGE);
        if (this.propMap.get("state") != null) {
            this.state = State.getState((String)this.propMap.get("state"));
        } else {
            this.state = State.ACTIVE;
            this.propMap.put("state", this.state.toString());
        }
        DocRouter.Range tmpRange = null;
        if (rangeObj instanceof DocRouter.Range) {
            tmpRange = (DocRouter.Range)rangeObj;
        } else if (rangeObj != null) {
            tmpRange = DocRouter.DEFAULT.fromString(rangeObj.toString());
        }
        this.range = tmpRange;
        this.parent = this.propMap.containsKey(PARENT) && this.propMap.get(PARENT) != null ? (String)this.propMap.get(PARENT) : null;
        this.replicationFactor = null;
        this.replicas = replicas != null ? replicas : this.makeReplicas((Map)this.propMap.get(REPLICAS));
        this.propMap.put(REPLICAS, this.replicas);
        Map rules = (Map)this.propMap.get("routingRules");
        if (rules != null) {
            this.routingRules = new HashMap<String, RoutingRule>();
            for (Map.Entry entry : rules.entrySet()) {
                Object o = entry.getValue();
                if (o instanceof Map) {
                    Map map = (Map)o;
                    RoutingRule rule = new RoutingRule((String)entry.getKey(), map);
                    this.routingRules.put((String)entry.getKey(), rule);
                    continue;
                }
                this.routingRules.put((String)entry.getKey(), (RoutingRule)o);
            }
        } else {
            this.routingRules = null;
        }
        this.leader = this.findLeader();
    }

    private Map<String, Replica> makeReplicas(Map<String, Object> genericReplicas) {
        if (genericReplicas == null) {
            return new HashMap<String, Replica>(1);
        }
        LinkedHashMap<String, Replica> result = new LinkedHashMap<String, Replica>(genericReplicas.size());
        for (Map.Entry<String, Object> entry : genericReplicas.entrySet()) {
            String name = entry.getKey();
            Object val = entry.getValue();
            Replica r = val instanceof Replica ? (Replica)val : new Replica(name, (Map)val);
            result.put(name, r);
        }
        return result;
    }

    private Replica findLeader() {
        for (Replica replica : this.replicas.values()) {
            if (replica.getStr(LEADER) == null) continue;
            return replica;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public Collection<Replica> getReplicas() {
        return this.replicas.values();
    }

    public List<Replica> getReplicas(Predicate<Replica> pred) {
        return this.replicas.values().stream().filter(pred).collect(Collectors.toList());
    }

    public Map<String, Replica> getReplicasMap() {
        return this.replicas;
    }

    public Map<String, Replica> getReplicasCopy() {
        return new LinkedHashMap<String, Replica>(this.replicas);
    }

    public Replica getLeader() {
        return this.leader;
    }

    public Replica getReplica(String replicaName) {
        return this.replicas.get(replicaName);
    }

    public DocRouter.Range getRange() {
        return this.range;
    }

    public State getState() {
        return this.state;
    }

    public String getParent() {
        return this.parent;
    }

    public Map<String, RoutingRule> getRoutingRules() {
        return this.routingRules;
    }

    @Override
    public String toString() {
        return this.name + ':' + JSONUtil.toJSON((Object)this.propMap);
    }

    @Override
    public void write(JSONWriter jsonWriter) {
        jsonWriter.write(this.propMap);
    }

    public static enum State {
        ACTIVE,
        INACTIVE,
        CONSTRUCTION,
        RECOVERY,
        RECOVERY_FAILED;


        public String toString() {
            return super.toString().toLowerCase(Locale.ROOT);
        }

        public static State getState(String stateStr) {
            return State.valueOf(stateStr.toUpperCase(Locale.ROOT));
        }
    }
}

