/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.testutils.suite;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.axiom.testutils.suite.TestCaseEx;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;

public abstract class TestSuiteBuilder {
    private final List excludes = new ArrayList();
    private TestSuite suite;

    public final void exclude(Class testClass, String filter) {
        try {
            this.excludes.add(new Exclude(testClass, filter == null ? null : FrameworkUtil.createFilter((String)filter)));
        }
        catch (InvalidSyntaxException ex) {
            throw new IllegalArgumentException("Invalid filter expression", ex);
        }
    }

    public final void exclude(Class testClass) {
        this.exclude(testClass, null);
    }

    public final void exclude(String filter) {
        this.exclude(null, filter);
    }

    protected abstract void addTests();

    public final TestSuite build() {
        this.suite = new TestSuite();
        this.addTests();
        return this.suite;
    }

    protected final void addTest(TestCaseEx test) {
        Iterator it = this.excludes.iterator();
        while (it.hasNext()) {
            if (!((Exclude)it.next()).accept(test)) continue;
            return;
        }
        this.suite.addTest((Test)test);
    }

    private static class Exclude {
        private final Class testClass;
        private final Filter filter;

        public Exclude(Class testClass, Filter filter) {
            this.testClass = testClass;
            this.filter = filter;
        }

        public boolean accept(TestCaseEx test) {
            return !(this.testClass != null && !((Object)((Object)test)).getClass().equals(this.testClass) || this.filter != null && !this.filter.match(test.getTestProperties()));
        }
    }
}

