/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.samskivert.mustache.Escapers;
import com.samskivert.mustache.Mustache;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConstants;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.GeneratorLanguage;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractScalaCodegen
extends DefaultCodegen {
    private final Logger LOGGER = LoggerFactory.getLogger(AbstractScalaCodegen.class);
    protected String modelPropertyNaming = CodegenConstants.ENUM_PROPERTY_NAMING_TYPE.camelCase.name();
    protected String invokerPackage = "org.openapitools.client";
    protected String sourceFolder = "src/main/scala";
    protected boolean stripPackageName = true;
    protected String dateLibrary = DateLibraries.java8.name();

    public AbstractScalaCodegen() {
        this.languageSpecificPrimitives.addAll(Arrays.asList("String", "boolean", "Boolean", "Double", "Int", "Long", "Float", "Object", "Any", "List", "Seq", "Map", "Array", "Byte"));
        this.reservedWords.addAll(Arrays.asList("abstract", "case", "catch", "class", "clone", "def", "do", "else", "extends", "false", "final", "finally", "for", "forSome", "if", "implicit", "import", "lazy", "match", "new", "null", "object", "override", "package", "private", "protected", "return", "sealed", "super", "this", "throw", "trait", "try", "true", "type", "val", "var", "while", "with", "yield"));
        this.typeMapping.put("ByteArray", "Array[Byte]");
        this.importMapping = new HashMap();
        this.importMapping.put("ListBuffer", "scala.collection.mutable.ListBuffer");
        this.importMapping.put("Seq", "scala.collection.immutable.Seq");
        this.importMapping.put("Set", "scala.collection.immutable.Set");
        this.importMapping.put("ListSet", "scala.collection.immutable.ListSet");
        this.importMapping.put("UUID", "java.util.UUID");
        this.importMapping.put("URI", "java.net.URI");
        this.importMapping.put("File", "java.io.File");
        this.importMapping.put("Timestamp", "java.sql.Timestamp");
        this.importMapping.put("HashMap", "java.util.HashMap");
        this.importMapping.put("Array", "java.util.List");
        this.importMapping.put("ArrayList", "java.util.ArrayList");
        this.importMapping.put("Date", "java.util.Date");
        this.importMapping.put("DateTime", "org.joda.time.*");
        this.importMapping.put("LocalDateTime", "org.joda.time.*");
        this.importMapping.put("LocalDate", "org.joda.time.*");
        this.importMapping.put("LocalTime", "org.joda.time.*");
        this.instantiationTypes.put("set", "Set");
        this.cliOptions.add(new CliOption("modelPackage", "package for generated models"));
        this.cliOptions.add(new CliOption("apiPackage", "package for generated api classes"));
        this.cliOptions.add(new CliOption("sourceFolder", "source folder for generated code"));
        this.cliOptions.add(new CliOption("modelPropertyNaming", "Naming convention for the property: 'camelCase', 'PascalCase', 'snake_case' and 'original', which keeps the original name").defaultValue(this.modelPropertyNaming));
        CliOption dateLibrary = new CliOption("dateLibrary", "Option. Date library to use").defaultValue(this.dateLibrary);
        HashMap<String, String> dateOptions = new HashMap<String, String>();
        dateOptions.put(DateLibraries.java8.name(), DateLibraries.java8.description);
        dateOptions.put(DateLibraries.joda.name(), DateLibraries.joda.description);
        dateLibrary.setEnum(dateOptions);
        this.cliOptions.add(dateLibrary);
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)System.getenv("SCALA_POST_PROCESS_FILE"))) {
            this.LOGGER.info("Environment variable SCALA_POST_PROCESS_FILE not defined so the Scala code may not be properly formatted. To define it, try 'export SCALA_POST_PROCESS_FILE=/usr/local/bin/scalafmt' (Linux/Mac)");
            this.LOGGER.info("NOTE: To enable file post-processing, 'enablePostProcessFile' must be set to `true` (--enable-post-process-file for CLI).");
        }
        if (this.additionalProperties.containsKey("invokerPackage")) {
            this.setInvokerPackage((String)this.additionalProperties.get("invokerPackage"));
        }
        if (this.additionalProperties.containsKey("sourceFolder")) {
            this.setSourceFolder((String)this.additionalProperties.get("sourceFolder"));
        }
        if (this.additionalProperties.containsKey("stripPackageName") && "false".equalsIgnoreCase(this.additionalProperties.get("stripPackageName").toString())) {
            this.stripPackageName = false;
            this.additionalProperties.put("stripPackageName", false);
            this.LOGGER.warn("stripPackageName=false. Compilation errors may occur if API type names clash with types in the default imports");
        }
        if (this.additionalProperties.containsKey("modelPropertyNaming")) {
            this.setModelPropertyNaming((String)this.additionalProperties.get("modelPropertyNaming"));
        }
        if (this.additionalProperties.containsKey("dateLibrary")) {
            this.setDateLibrary(this.additionalProperties.get("dateLibrary").toString(), false);
        }
        if (DateLibraries.java8.name().equals(this.dateLibrary)) {
            this.importMapping.put("LocalDate", "java.time.LocalDate");
            this.importMapping.put("OffsetDateTime", "java.time.OffsetDateTime");
            this.typeMapping.put("date", "LocalDate");
            this.typeMapping.put("DateTime", "OffsetDateTime");
            this.additionalProperties.put("java8", "true");
        } else if (DateLibraries.joda.name().equals(this.dateLibrary)) {
            this.importMapping.put("LocalDate", "org.joda.time.LocalDate");
            this.importMapping.put("DateTime", "org.joda.time.DateTime");
            this.importMapping.put("LocalDateTime", "org.joda.time.LocalDateTime");
            this.importMapping.put("LocalTime", "org.joda.time.LocalTime");
            this.typeMapping.put("date", "LocalDate");
            this.typeMapping.put("DateTime", "DateTime");
            this.additionalProperties.put("joda", "true");
        }
    }

    public void setDateLibrary(String dateLibrary, boolean withLegacy) {
        if (withLegacy && dateLibrary.equals(DateLibraries.legacy.name())) {
            this.dateLibrary = dateLibrary;
            return;
        }
        for (DateLibraries dateLib : DateLibraries.values()) {
            if (!dateLib.name().equals(dateLibrary)) continue;
            this.dateLibrary = dateLibrary;
            return;
        }
        throw new IllegalArgumentException("Invalid dateLibrary. Must be 'java8' or 'joda'");
    }

    public String getDateLibrary() {
        return this.dateLibrary;
    }

    public void setModelPropertyNaming(String naming) {
        try {
            this.modelPropertyNaming = CodegenConstants.ENUM_PROPERTY_NAMING_TYPE.valueOf(naming).name();
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Invalid model property naming '" + naming + "'. Must be 'original', 'camelCase', 'PascalCase' or 'snake_case'");
        }
    }

    public String getModelPropertyNaming() {
        return this.modelPropertyNaming;
    }

    @Override
    public String toVarName(String name) {
        String varName = this.sanitizeName(name);
        if ("_".equals(varName)) {
            varName = "_u";
        }
        if (!varName.matches("^[A-Z_0-9]*$")) {
            varName = this.getNameUsingModelPropertyNaming(varName);
        }
        if (this.isReservedWord(varName) || varName.matches("^\\d.*")) {
            varName = this.escapeReservedWord(varName);
        }
        return varName;
    }

    public String getNameUsingModelPropertyNaming(String name) {
        switch (CodegenConstants.MODEL_PROPERTY_NAMING_TYPE.valueOf(this.getModelPropertyNaming())) {
            case original: {
                return name;
            }
            case camelCase: {
                return StringUtils.camelize(name, true);
            }
            case PascalCase: {
                return StringUtils.camelize(name);
            }
            case snake_case: {
                return StringUtils.underscore(name);
            }
        }
        throw new IllegalArgumentException("Invalid model property naming '" + name + "'. Must be 'original', 'camelCase', 'PascalCase' or 'snake_case'");
    }

    public String getSourceFolder() {
        return this.sourceFolder;
    }

    public void setSourceFolder(String sourceFolder) {
        this.sourceFolder = sourceFolder;
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "`" + name + "`";
    }

    @Override
    public Mustache.Compiler processCompiler(Mustache.Compiler compiler) {
        Mustache.Escaper SCALA = new Mustache.Escaper(){

            public String escape(String text) {
                if (text.startsWith("`") && text.endsWith("`")) {
                    String unescaped = text.substring(1, text.length() - 1);
                    return "`" + Escapers.HTML.escape(unescaped) + "`";
                }
                return Escapers.HTML.escape(text);
            }
        };
        return compiler.withEscaper(SCALA);
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.modelPackage().replace('.', File.separatorChar);
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            return this.getSchemaType(p) + "[" + this.getTypeDeclaration(inner) + "]";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = this.getAdditionalProperties(p);
            return this.getSchemaType(p) + "[String, " + this.getTypeDeclaration(inner) + "]";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String getSchemaType(Schema p) {
        String openAPIType = super.getSchemaType(p);
        if (ModelUtils.isSet(p)) {
            openAPIType = "set";
        }
        if (this.typeMapping.containsKey(openAPIType)) {
            return (String)this.typeMapping.get(openAPIType);
        }
        return this.toModelName(openAPIType);
    }

    @Override
    public String toInstantiationType(Schema p) {
        if (ModelUtils.isMapSchema(p)) {
            String inner = this.getSchemaType(this.getAdditionalProperties(p));
            return (String)this.instantiationTypes.get("map") + "[String, " + inner + "]";
        }
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            String inner = this.getSchemaType(ap.getItems());
            return (ModelUtils.isSet((Schema)ap) ? (String)this.instantiationTypes.get("set") : (String)this.instantiationTypes.get("array")) + "[" + inner + "]";
        }
        return null;
    }

    @Override
    public String toDefaultValue(Schema p) {
        if (p.getDefault() != null) {
            return p.getDefault().toString();
        }
        if (ModelUtils.isBooleanSchema(p)) {
            return null;
        }
        if (ModelUtils.isDateSchema(p)) {
            return null;
        }
        if (ModelUtils.isDateTimeSchema(p)) {
            return null;
        }
        if (ModelUtils.isNumberSchema(p)) {
            return null;
        }
        if (ModelUtils.isIntegerSchema(p)) {
            return null;
        }
        if (ModelUtils.isMapSchema(p)) {
            String inner = this.getSchemaType(this.getAdditionalProperties(p));
            return "new HashMap[String, " + inner + "]() ";
        }
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            String inner = this.getSchemaType(ap.getItems());
            String genericType = ModelUtils.isSet((Schema)ap) ? (String)this.instantiationTypes.get("set") : (String)this.instantiationTypes.get("array");
            if ("List".equals(genericType) || "Set".equals(genericType) || "Seq".equals(genericType) || "Array".equals(genericType) || "Vector".equals(genericType) || "IndexedSeq".equals(genericType) || "Iterable".equals(genericType) || "ListSet".equals(genericType)) {
                return genericType + ".empty[" + inner + "] ";
            }
            return "new " + genericType + "[" + inner + "]() ";
        }
        if (ModelUtils.isStringSchema(p)) {
            return null;
        }
        return null;
    }

    @Override
    public CodegenProperty fromProperty(String name, Schema p) {
        ArraySchema as;
        CodegenProperty prop = super.fromProperty(name, p);
        if (ModelUtils.isArraySchema(p) && ModelUtils.isSet((Schema)(as = (ArraySchema)p))) {
            prop.containerType = "set";
        }
        return prop;
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        List imports = (List)objs.get("imports");
        String prefix = this.modelPackage() + ".";
        Iterator iterator = imports.iterator();
        while (iterator.hasNext()) {
            String _import = (String)((Map)iterator.next()).get("import");
            if (!_import.startsWith(prefix)) continue;
            iterator.remove();
        }
        return objs;
    }

    @Override
    public String toModelName(String name) {
        String sanitizedName = this.sanitizeName(this.modelNamePrefix + this.stripPackageName(name) + this.modelNameSuffix);
        String camelizedName = StringUtils.camelize(sanitizedName);
        if (this.isReservedWord(camelizedName)) {
            String modelName = "Model" + camelizedName;
            this.LOGGER.warn("{} (reserved word) cannot be used as model name. Renamed to {}", (Object)camelizedName, (Object)modelName);
            return modelName;
        }
        if (name.matches("^\\d.*")) {
            String modelName = "Model" + camelizedName;
            this.LOGGER.warn("{} (model name starts with number) cannot be used as model name. Renamed to {}", (Object)name, (Object)modelName);
            return modelName;
        }
        return camelizedName;
    }

    @Override
    public String toModelFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    protected String formatIdentifier(String name, boolean capitalized) {
        String identifier = StringUtils.camelize(this.sanitizeName(name), true);
        if (capitalized) {
            identifier = org.apache.commons.lang3.StringUtils.capitalize((String)identifier);
        }
        if (identifier.matches("[a-zA-Z_$][\\w_$]+") && !this.isReservedWord(identifier)) {
            return identifier;
        }
        return this.escapeReservedWord(identifier);
    }

    protected String stripPackageName(String input) {
        if (!this.stripPackageName || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)input) || input.lastIndexOf(".") < 0) {
            return input;
        }
        int lastIndexOfDot = input.lastIndexOf(".");
        return input.substring(lastIndexOfDot + 1);
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public void postProcessFile(File file, String fileType) {
        if (file == null) {
            return;
        }
        String scalaPostProcessFile = System.getenv("SCALA_POST_PROCESS_FILE");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)scalaPostProcessFile)) {
            return;
        }
        if ("scala".equals(FilenameUtils.getExtension((String)file.toString()))) {
            String command = scalaPostProcessFile + " " + file;
            try {
                Process p = Runtime.getRuntime().exec(command);
                int exitValue = p.waitFor();
                if (exitValue != 0) {
                    this.LOGGER.error("Error running the command ({}). Exit value: {}", (Object)command, (Object)exitValue);
                } else {
                    this.LOGGER.info("Successfully executed: {}", (Object)command);
                }
            }
            catch (IOException | InterruptedException e) {
                this.LOGGER.error("Error running the command ({}). Exception: {}", (Object)command, (Object)e.getMessage());
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public String toOperationId(String operationId) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)operationId)) {
            throw new RuntimeException("Empty method/operation name (operationId) not allowed");
        }
        if (this.isReservedWord(operationId = StringUtils.camelize(this.sanitizeName(operationId), true))) {
            String newOperationId = StringUtils.camelize("call_" + operationId, true);
            this.LOGGER.warn("{} (reserved word) cannot be used as method name. Renamed to {}", (Object)operationId, (Object)newOperationId);
            return newOperationId;
        }
        if (operationId.matches("^\\d.*")) {
            this.LOGGER.warn(operationId + " (starting with a number) cannot be used as method sname. Renamed to " + StringUtils.camelize("call_" + operationId), (Object)true);
            operationId = StringUtils.camelize("call_" + operationId, true);
        }
        return operationId;
    }

    public void setInvokerPackage(String invokerPackage) {
        this.invokerPackage = invokerPackage;
    }

    @Override
    public GeneratorLanguage generatorLanguage() {
        return GeneratorLanguage.SCALA;
    }

    protected static enum DateLibraries {
        java8("Java 8 native JSR310 (preferred for JDK 1.8+)"),
        joda("Joda (for legacy app)"),
        legacy("Backport to http-client (deprecated)");

        private final String description;

        private DateLibraries(String description) {
            this.description = description;
        }
    }
}

