package org.openqa.selenium.devtools.v103.page.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * List of FinalStatus reasons for Prerender2.
 */
public enum PrerenderFinalStatus {

    ACTIVATED("Activated"),
    DESTROYED("Destroyed"),
    LOWENDDEVICE("LowEndDevice"),
    CROSSORIGINREDIRECT("CrossOriginRedirect"),
    CROSSORIGINNAVIGATION("CrossOriginNavigation"),
    INVALIDSCHEMEREDIRECT("InvalidSchemeRedirect"),
    INVALIDSCHEMENAVIGATION("InvalidSchemeNavigation"),
    INPROGRESSNAVIGATION("InProgressNavigation"),
    NAVIGATIONREQUESTBLOCKEDBYCSP("NavigationRequestBlockedByCsp"),
    MAINFRAMENAVIGATION("MainFrameNavigation"),
    MOJOBINDERPOLICY("MojoBinderPolicy"),
    RENDERERPROCESSCRASHED("RendererProcessCrashed"),
    RENDERERPROCESSKILLED("RendererProcessKilled"),
    DOWNLOAD("Download"),
    TRIGGERDESTROYED("TriggerDestroyed"),
    NAVIGATIONNOTCOMMITTED("NavigationNotCommitted"),
    NAVIGATIONBADHTTPSTATUS("NavigationBadHttpStatus"),
    CLIENTCERTREQUESTED("ClientCertRequested"),
    NAVIGATIONREQUESTNETWORKERROR("NavigationRequestNetworkError"),
    MAXNUMOFRUNNINGPRERENDERSEXCEEDED("MaxNumOfRunningPrerendersExceeded"),
    CANCELALLHOSTSFORTESTING("CancelAllHostsForTesting"),
    DIDFAILLOAD("DidFailLoad"),
    STOP("Stop"),
    SSLCERTIFICATEERROR("SslCertificateError"),
    LOGINAUTHREQUESTED("LoginAuthRequested"),
    UACHANGEREQUIRESRELOAD("UaChangeRequiresReload"),
    BLOCKEDBYCLIENT("BlockedByClient"),
    AUDIOOUTPUTDEVICEREQUESTED("AudioOutputDeviceRequested"),
    MIXEDCONTENT("MixedContent"),
    TRIGGERBACKGROUNDED("TriggerBackgrounded"),
    EMBEDDERTRIGGEREDANDSAMEORIGINREDIRECTED("EmbedderTriggeredAndSameOriginRedirected"),
    EMBEDDERTRIGGEREDANDCROSSORIGINREDIRECTED("EmbedderTriggeredAndCrossOriginRedirected"),
    EMBEDDERTRIGGEREDANDDESTROYED("EmbedderTriggeredAndDestroyed");

    private String value;

    PrerenderFinalStatus(String value) {
        this.value = value;
    }

    public static PrerenderFinalStatus fromString(String s) {
        return java.util.Arrays.stream(PrerenderFinalStatus.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within PrerenderFinalStatus "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static PrerenderFinalStatus fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
