package org.openqa.selenium.devtools.v104.page.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Fired when a prerender attempt is completed.
 */
public class PrerenderAttemptCompleted {

    private final org.openqa.selenium.devtools.v104.page.model.FrameId initiatingFrameId;

    private final java.lang.String prerenderingUrl;

    private final org.openqa.selenium.devtools.v104.page.model.PrerenderFinalStatus finalStatus;

    public PrerenderAttemptCompleted(org.openqa.selenium.devtools.v104.page.model.FrameId initiatingFrameId, java.lang.String prerenderingUrl, org.openqa.selenium.devtools.v104.page.model.PrerenderFinalStatus finalStatus) {
        this.initiatingFrameId = java.util.Objects.requireNonNull(initiatingFrameId, "initiatingFrameId is required");
        this.prerenderingUrl = java.util.Objects.requireNonNull(prerenderingUrl, "prerenderingUrl is required");
        this.finalStatus = java.util.Objects.requireNonNull(finalStatus, "finalStatus is required");
    }

    /**
     * The frame id of the frame initiating prerendering.
     */
    public org.openqa.selenium.devtools.v104.page.model.FrameId getInitiatingFrameId() {
        return initiatingFrameId;
    }

    public java.lang.String getPrerenderingUrl() {
        return prerenderingUrl;
    }

    public org.openqa.selenium.devtools.v104.page.model.PrerenderFinalStatus getFinalStatus() {
        return finalStatus;
    }

    private static PrerenderAttemptCompleted fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v104.page.model.FrameId initiatingFrameId = null;
        java.lang.String prerenderingUrl = null;
        org.openqa.selenium.devtools.v104.page.model.PrerenderFinalStatus finalStatus = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "initiatingFrameId":
                    initiatingFrameId = input.read(org.openqa.selenium.devtools.v104.page.model.FrameId.class);
                    break;
                case "prerenderingUrl":
                    prerenderingUrl = input.nextString();
                    break;
                case "finalStatus":
                    finalStatus = input.read(org.openqa.selenium.devtools.v104.page.model.PrerenderFinalStatus.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new PrerenderAttemptCompleted(initiatingFrameId, prerenderingUrl, finalStatus);
    }
}
