/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v117.browser.model;

import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@Beta
public class Bucket {
    private final Integer low;
    private final Integer high;
    private final Integer count;

    public Bucket(Integer low, Integer high, Integer count) {
        this.low = Objects.requireNonNull(low, "low is required");
        this.high = Objects.requireNonNull(high, "high is required");
        this.count = Objects.requireNonNull(count, "count is required");
    }

    public Integer getLow() {
        return this.low;
    }

    public Integer getHigh() {
        return this.high;
    }

    public Integer getCount() {
        return this.count;
    }

    private static Bucket fromJson(JsonInput input) {
        Integer low = 0;
        Integer high = 0;
        Integer count = 0;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "low": {
                    low = input.nextNumber().intValue();
                    continue block10;
                }
                case "high": {
                    high = input.nextNumber().intValue();
                    continue block10;
                }
                case "count": {
                    count = input.nextNumber().intValue();
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new Bucket(low, high, count);
    }
}

