/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v99.audits.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v99.audits.model.AffectedFrame;
import org.openqa.selenium.devtools.v99.audits.model.AffectedRequest;
import org.openqa.selenium.devtools.v99.audits.model.AttributionReportingIssueType;
import org.openqa.selenium.devtools.v99.dom.model.BackendNodeId;
import org.openqa.selenium.json.JsonInput;

public class AttributionReportingIssueDetails {
    private final AttributionReportingIssueType violationType;
    private final Optional<AffectedFrame> frame;
    private final Optional<AffectedRequest> request;
    private final Optional<BackendNodeId> violatingNodeId;
    private final Optional<String> invalidParameter;

    public AttributionReportingIssueDetails(AttributionReportingIssueType violationType, Optional<AffectedFrame> frame, Optional<AffectedRequest> request, Optional<BackendNodeId> violatingNodeId, Optional<String> invalidParameter) {
        this.violationType = Objects.requireNonNull(violationType, "violationType is required");
        this.frame = frame;
        this.request = request;
        this.violatingNodeId = violatingNodeId;
        this.invalidParameter = invalidParameter;
    }

    public AttributionReportingIssueType getViolationType() {
        return this.violationType;
    }

    public Optional<AffectedFrame> getFrame() {
        return this.frame;
    }

    public Optional<AffectedRequest> getRequest() {
        return this.request;
    }

    public Optional<BackendNodeId> getViolatingNodeId() {
        return this.violatingNodeId;
    }

    public Optional<String> getInvalidParameter() {
        return this.invalidParameter;
    }

    private static AttributionReportingIssueDetails fromJson(JsonInput input) {
        AttributionReportingIssueType violationType = null;
        Optional<AffectedFrame> frame = Optional.empty();
        Optional<AffectedRequest> request = Optional.empty();
        Optional<BackendNodeId> violatingNodeId = Optional.empty();
        Optional<String> invalidParameter = Optional.empty();
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "violationType": {
                    violationType = (AttributionReportingIssueType)((Object)input.read(AttributionReportingIssueType.class));
                    continue block14;
                }
                case "frame": {
                    frame = Optional.ofNullable((AffectedFrame)input.read(AffectedFrame.class));
                    continue block14;
                }
                case "request": {
                    request = Optional.ofNullable((AffectedRequest)input.read(AffectedRequest.class));
                    continue block14;
                }
                case "violatingNodeId": {
                    violatingNodeId = Optional.ofNullable((BackendNodeId)input.read(BackendNodeId.class));
                    continue block14;
                }
                case "invalidParameter": {
                    invalidParameter = Optional.ofNullable(input.nextString());
                    continue block14;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new AttributionReportingIssueDetails(violationType, frame, request, violatingNodeId, invalidParameter);
    }
}

