/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.ssl;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.ssl.DefaultSslManagerBundle;
import org.springframework.boot.ssl.FixedTrustManagerFactory;
import org.springframework.boot.ssl.SslBundleKey;
import org.springframework.boot.ssl.SslStoreBundle;
import org.springframework.util.Assert;

public interface SslManagerBundle {
    default public KeyManager[] getKeyManagers() {
        return this.getKeyManagerFactory().getKeyManagers();
    }

    public KeyManagerFactory getKeyManagerFactory();

    default public TrustManager[] getTrustManagers() {
        return this.getTrustManagerFactory().getTrustManagers();
    }

    public TrustManagerFactory getTrustManagerFactory();

    default public SSLContext createSslContext(String protocol) {
        try {
            SSLContext sslContext = SSLContext.getInstance(protocol);
            sslContext.init(this.getKeyManagers(), this.getTrustManagers(), null);
            return sslContext;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not load SSL context: " + ex.getMessage(), ex);
        }
    }

    public static SslManagerBundle of(final KeyManagerFactory keyManagerFactory, final TrustManagerFactory trustManagerFactory) {
        Assert.notNull((Object)keyManagerFactory, (String)"'keyManagerFactory' must not be null");
        Assert.notNull((Object)trustManagerFactory, (String)"'trustManagerFactory' must not be null");
        return new SslManagerBundle(){

            @Override
            public KeyManagerFactory getKeyManagerFactory() {
                return keyManagerFactory;
            }

            @Override
            public TrustManagerFactory getTrustManagerFactory() {
                return trustManagerFactory;
            }
        };
    }

    public static SslManagerBundle from(@Nullable SslStoreBundle storeBundle, @Nullable SslBundleKey key) {
        return new DefaultSslManagerBundle(storeBundle, key);
    }

    public static SslManagerBundle from(TrustManagerFactory trustManagerFactory) {
        Assert.notNull((Object)trustManagerFactory, (String)"'trustManagerFactory' must not be null");
        KeyManagerFactory defaultKeyManagerFactory = SslManagerBundle.createDefaultKeyManagerFactory();
        return SslManagerBundle.of(defaultKeyManagerFactory, trustManagerFactory);
    }

    public static SslManagerBundle from(TrustManager ... trustManagers) {
        Assert.notNull((Object)trustManagers, (String)"'trustManagers' must not be null");
        KeyManagerFactory defaultKeyManagerFactory = SslManagerBundle.createDefaultKeyManagerFactory();
        TrustManagerFactory defaultTrustManagerFactory = SslManagerBundle.createDefaultTrustManagerFactory();
        return SslManagerBundle.of(defaultKeyManagerFactory, FixedTrustManagerFactory.of(defaultTrustManagerFactory, trustManagers));
    }

    private static TrustManagerFactory createDefaultTrustManagerFactory() {
        TrustManagerFactory trustManagerFactory;
        String defaultAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
        try {
            trustManagerFactory = TrustManagerFactory.getInstance(defaultAlgorithm);
            trustManagerFactory.init((KeyStore)null);
        }
        catch (KeyStoreException | NoSuchAlgorithmException ex) {
            throw new IllegalStateException("Unable to create TrustManagerFactory for default '%s' algorithm".formatted(defaultAlgorithm), ex);
        }
        return trustManagerFactory;
    }

    private static KeyManagerFactory createDefaultKeyManagerFactory() {
        KeyManagerFactory keyManagerFactory;
        String defaultAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
        try {
            keyManagerFactory = KeyManagerFactory.getInstance(defaultAlgorithm);
            keyManagerFactory.init(null, null);
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException ex) {
            throw new IllegalStateException("Unable to create KeyManagerFactory for default '%s' algorithm".formatted(defaultAlgorithm), ex);
        }
        return keyManagerFactory;
    }
}

