/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.aws.config.xml;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.aws.outbound.S3MessageHandler;
import org.springframework.integration.config.xml.AbstractConsumerEndpointParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class S3OutboundGatewayParser
extends AbstractConsumerEndpointParser {
    protected String getInputChannelAttributeName() {
        return "request-channel";
    }

    protected BeanDefinitionBuilder parseHandler(Element element, ParserContext parserContext) {
        BeanDefinition destinationKeyExpression;
        BeanDefinition destinationBucketExpression;
        BeanDefinition objectAclExpression;
        String transferManager;
        boolean hasTransferManager;
        String s3 = element.getAttribute("s3");
        boolean hasS3 = StringUtils.hasText((String)s3);
        if (hasS3 == (hasTransferManager = StringUtils.hasText((String)(transferManager = element.getAttribute("transfer-manager"))))) {
            parserContext.getReaderContext().error("One and only of 's3' and 'transfer-manager' attributes must be provided", (Object)element);
        }
        BeanDefinition bucketExpression = IntegrationNamespaceUtils.createExpressionDefinitionFromValueOrExpression((String)"bucket", (String)"bucket-expression", (ParserContext)parserContext, (Element)element, (boolean)true);
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(S3MessageHandler.class).addConstructorArgReference(hasS3 ? s3 : transferManager).addConstructorArgValue((Object)bucketExpression).addConstructorArgValue((Object)true);
        BeanDefinition commandExpression = IntegrationNamespaceUtils.createExpressionDefinitionFromValueOrExpression((String)"command", (String)"command-expression", (ParserContext)parserContext, (Element)element, (boolean)false);
        if (commandExpression != null) {
            builder.addPropertyValue("commandExpression", (Object)commandExpression);
        }
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"progress-listener");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"upload-metadata-provider");
        BeanDefinition keyExpression = IntegrationNamespaceUtils.createExpressionDefIfAttributeDefined((String)"key-expression", (Element)element);
        if (keyExpression != null) {
            builder.addPropertyValue("keyExpression", (Object)keyExpression);
        }
        if ((objectAclExpression = IntegrationNamespaceUtils.createExpressionDefIfAttributeDefined((String)"object-acl-expression", (Element)element)) != null) {
            builder.addPropertyValue("objectAclExpression", (Object)objectAclExpression);
        }
        if ((destinationBucketExpression = IntegrationNamespaceUtils.createExpressionDefIfAttributeDefined((String)"destination-bucket-expression", (Element)element)) != null) {
            builder.addPropertyValue("destinationBucketExpression", (Object)destinationBucketExpression);
        }
        if ((destinationKeyExpression = IntegrationNamespaceUtils.createExpressionDefIfAttributeDefined((String)"destination-key-expression", (Element)element)) != null) {
            builder.addPropertyValue("destinationKeyExpression", (Object)destinationKeyExpression);
        }
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"reply-timeout", (String)"sendTimeout");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"reply-channel", (String)"outputChannel");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"resource-id-resolver");
        return builder;
    }
}

