/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.kafka.dsl;

import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.integration.dsl.ComponentsRegistration;
import org.springframework.integration.dsl.MessageProducerSpec;
import org.springframework.integration.kafka.dsl.KafkaMessageListenerContainerSpec;
import org.springframework.integration.kafka.inbound.KafkaMessageDrivenChannelAdapter;
import org.springframework.kafka.listener.AbstractMessageListenerContainer;
import org.springframework.kafka.listener.adapter.RecordFilterStrategy;
import org.springframework.kafka.support.converter.BatchMessageConverter;
import org.springframework.kafka.support.converter.MessageConverter;
import org.springframework.kafka.support.converter.RecordMessageConverter;
import org.springframework.retry.RecoveryCallback;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;

public class KafkaMessageDrivenChannelAdapterSpec<K, V, S extends KafkaMessageDrivenChannelAdapterSpec<K, V, S>>
extends MessageProducerSpec<S, KafkaMessageDrivenChannelAdapter<K, V>> {
    KafkaMessageDrivenChannelAdapterSpec(AbstractMessageListenerContainer<K, V> messageListenerContainer, KafkaMessageDrivenChannelAdapter.ListenerMode listenerMode) {
        super(new KafkaMessageDrivenChannelAdapter<K, V>(messageListenerContainer, listenerMode));
    }

    public S messageConverter(MessageConverter messageConverter) {
        ((KafkaMessageDrivenChannelAdapter)((Object)this.target)).setMessageConverter(messageConverter);
        return (S)((Object)((KafkaMessageDrivenChannelAdapterSpec)this._this()));
    }

    public S recordMessageConverter(RecordMessageConverter messageConverter) {
        ((KafkaMessageDrivenChannelAdapter)((Object)this.target)).setRecordMessageConverter(messageConverter);
        return (S)((Object)((KafkaMessageDrivenChannelAdapterSpec)this._this()));
    }

    public S batchMessageConverter(BatchMessageConverter messageConverter) {
        ((KafkaMessageDrivenChannelAdapter)((Object)this.target)).setBatchMessageConverter(messageConverter);
        return (S)((Object)((KafkaMessageDrivenChannelAdapterSpec)this._this()));
    }

    public S recordFilterStrategy(RecordFilterStrategy<K, V> recordFilterStrategy) {
        ((KafkaMessageDrivenChannelAdapter)((Object)this.target)).setRecordFilterStrategy(recordFilterStrategy);
        return (S)((Object)((KafkaMessageDrivenChannelAdapterSpec)this._this()));
    }

    public S ackDiscarded(boolean ackDiscarded) {
        ((KafkaMessageDrivenChannelAdapter)((Object)this.target)).setAckDiscarded(ackDiscarded);
        return (S)((Object)((KafkaMessageDrivenChannelAdapterSpec)this._this()));
    }

    public S retryTemplate(RetryTemplate retryTemplate) {
        ((KafkaMessageDrivenChannelAdapter)((Object)this.target)).setRetryTemplate(retryTemplate);
        return (S)((Object)((KafkaMessageDrivenChannelAdapterSpec)this._this()));
    }

    public S recoveryCallback(RecoveryCallback<? extends Object> recoveryCallback) {
        ((KafkaMessageDrivenChannelAdapter)((Object)this.target)).setRecoveryCallback(recoveryCallback);
        return (S)((Object)((KafkaMessageDrivenChannelAdapterSpec)this._this()));
    }

    public S filterInRetry(boolean filterInRetry) {
        ((KafkaMessageDrivenChannelAdapter)((Object)this.target)).setFilterInRetry(filterInRetry);
        return (S)((Object)((KafkaMessageDrivenChannelAdapterSpec)this._this()));
    }

    public static class KafkaMessageDrivenChannelAdapterListenerContainerSpec<K, V>
    extends KafkaMessageDrivenChannelAdapterSpec<K, V, KafkaMessageDrivenChannelAdapterListenerContainerSpec<K, V>>
    implements ComponentsRegistration {
        private final KafkaMessageListenerContainerSpec<K, V> spec;

        KafkaMessageDrivenChannelAdapterListenerContainerSpec(KafkaMessageListenerContainerSpec<K, V> spec, KafkaMessageDrivenChannelAdapter.ListenerMode listenerMode) {
            super((AbstractMessageListenerContainer)spec.get(), listenerMode);
            this.spec = spec;
        }

        public KafkaMessageDrivenChannelAdapterListenerContainerSpec<K, V> configureListenerContainer(Consumer<KafkaMessageListenerContainerSpec<K, V>> configurer) {
            Assert.notNull(configurer, (String)"The 'configurer' cannot be null");
            configurer.accept(this.spec);
            return (KafkaMessageDrivenChannelAdapterListenerContainerSpec)this._this();
        }

        public Map<Object, String> getComponentsToRegister() {
            return Collections.singletonMap(this.spec.get(), this.spec.getId());
        }
    }
}

