/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.msp.lfasr;

import com.iflytek.msp.lfasr.exception.LfasrException;
import com.iflytek.msp.lfasr.model.Message;
import com.iflytek.msp.lfasr.model.Signature;
import com.iflytek.msp.lfasr.process.Processor;
import com.iflytek.msp.lfasr.process.task.MergeTask;
import com.iflytek.msp.lfasr.process.task.PrepareTask;
import com.iflytek.msp.lfasr.process.task.PullResultTask;
import com.iflytek.msp.lfasr.process.task.QueryProgressTask;
import com.iflytek.msp.lfasr.process.task.UploadTask;
import com.iflytek.msp.lfasr.util.SliceIdGenerator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class LfasrClient {
    private static final Logger LOGGER = Logger.getLogger(LfasrClient.class);
    private static final int FILE_UPLOAD_MAXSIZE = 524288000;
    private static final int SLICE_SIZE = 0xA00000;
    private Signature signature;
    private volatile Processor processor;

    private LfasrClient() {
    }

    public static LfasrClient getInstance(String appId, String secretKey) {
        return LfasrClient.getInstance(appId, secretKey, null);
    }

    public static LfasrClient getInstance(String appId, String secretKey, String proxyUrl) {
        return LfasrClient.getInstance(appId, secretKey, 10, 50, proxyUrl);
    }

    public static LfasrClient getInstance(String appId, String secretKey, int coreThreads, int maxThreads, String proxyUrl) {
        return LfasrClient.getInstance(appId, secretKey, coreThreads, maxThreads, 50, 10000, 30000, proxyUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LfasrClient getInstance(String appId, String secretKey, int coreThreads, int maxThreads, int maxConnections, int connTimeout, int soTimeout, String proxyUrl) {
        LfasrClient instance = SingletonHolder.singleton;
        try {
            instance.signature = new Signature(appId, secretKey);
        }
        catch (NoSuchAlgorithmException | SignatureException e) {
            LOGGER.error((Object)"{\"ok\":\"-1\", \"errNo\":\"26002\", \"failed\":\"\u8f6c\u5199\u53c2\u6570\u5ba2\u6237\u7aef\u751f\u6210\u7b7e\u540d\u9519\u8bef!\", \"data\":\"\"}");
            throw new LfasrException("{\"ok\":\"-1\", \"errNo\":\"26002\", \"failed\":\"\u8f6c\u5199\u53c2\u6570\u5ba2\u6237\u7aef\u751f\u6210\u7b7e\u540d\u9519\u8bef!\", \"data\":\"\"}");
        }
        if (instance.processor == null) {
            Class<LfasrClient> clazz = LfasrClient.class;
            synchronized (LfasrClient.class) {
                if (instance.processor == null) {
                    instance.processor = Processor.build(coreThreads, maxThreads, maxConnections, connTimeout, soTimeout, proxyUrl);
                }
                // ** MonitorExit[var9_10] (shouldn't be in output)
            }
        } else {
            LOGGER.warn((Object)"Processor\u5b9e\u4f8b\u5df2\u5b58\u5728\uff0c\u4e0d\u91cd\u590d\u6784\u5efaProcessor\u3002");
        }
        return instance;
    }

    public Message upload(String audioFilePath) {
        return this.upload(audioFilePath, new HashMap<String, String>());
    }

    public Message upload(String audioFilePath, Map<String, String> param) {
        if (audioFilePath == null) {
            LOGGER.error((Object)"audioFilePath is null!");
            throw new LfasrException("{\"ok\":\"-1\", \"errNo\":\"26001\", \"failed\":\"\u8f6c\u5199\u53c2\u6570\u4e0a\u4f20\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u6216\u6587\u4ef6\u4e0d\u5b58\u5728!\", \"data\":\"\"}");
        }
        File audio = new File(audioFilePath);
        if (!audio.exists()) {
            LOGGER.error((Object)(audioFilePath + " is not exists!"));
            throw new LfasrException("{\"ok\":\"-1\", \"errNo\":\"26001\", \"failed\":\"\u8f6c\u5199\u53c2\u6570\u4e0a\u4f20\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u6216\u6587\u4ef6\u4e0d\u5b58\u5728!\", \"data\":\"\"}");
        }
        long length = audio.length();
        if (length > 524288000L) {
            LOGGER.error((Object)(audioFilePath + " is too large! (500M)"));
            throw new LfasrException("{\"ok\":\"-1\", \"errNo\":\"26003\", \"failed\":\"\u8f6c\u5199\u672c\u5730\u6587\u4ef6\u4e0a\u4f20\u8d85\u8fc7\u9650\u5b9a\u5927\u5c0f500M!\", \"data\":\"\"}");
        }
        long sliceNum = length / 0xA00000L + (long)(length % 0xA00000L == 0L ? 0 : 1);
        param.put("file_len", length + "");
        param.put("file_name", audio.getName());
        param.put("slice_num", sliceNum + "");
        Message message = this.processor.exec(new PrepareTask(this.signature, param));
        String taskId = message.getData();
        LOGGER.info((Object)("taskId: " + taskId));
        try (FileInputStream fis = new FileInputStream(audio);){
            int len;
            byte[] slice = new byte[0xA00000];
            SliceIdGenerator generator = new SliceIdGenerator();
            while ((len = fis.read(slice)) > 0) {
                byte[] data = Arrays.copyOfRange(slice, 0, len);
                UploadTask task = new UploadTask(this.signature, taskId, generator.getNextSliceId(), data);
                this.processor.exec(task);
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)(audioFilePath + ", " + e.getMessage()));
            throw new LfasrException("{\"ok\":\"-1\", \"errNo\":\"26004\", \"failed\":\"\u8f6c\u5199\u4e0a\u4f20\u6587\u4ef6\u8bfb\u53d6\u9519\u8bef!\", \"data\":\"\"}");
        }
        this.processor.exec(new MergeTask(this.signature, taskId));
        return message;
    }

    public Message getProgress(String taskId) {
        return this.processor.exec(new QueryProgressTask(this.signature, taskId));
    }

    public Message getResult(String taskId) {
        return this.processor.exec(new PullResultTask(this.signature, taskId));
    }

    private static class SingletonHolder {
        private static LfasrClient singleton = new LfasrClient();

        private SingletonHolder() {
        }
    }
}

