/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.msp.lfasr.connect;

import com.iflytek.msp.lfasr.exception.LfasrException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class Connector {
    private static final Logger LOGGER = Logger.getLogger(Connector.class);
    private CloseableHttpClient httpClient;
    private PoolingHttpClientConnectionManager pool = new PoolingHttpClientConnectionManager();
    private RequestConfig config;

    private Connector() {
    }

    public static Connector build(int maxConnections, int connTimeout, int soTimeout, String proxyUrl) {
        Connector connector = ConnectorBuilder.connector;
        connector.pool.setMaxTotal(maxConnections);
        RequestConfig.Builder builder = RequestConfig.custom().setConnectionRequestTimeout(5000).setConnectTimeout(connTimeout).setSocketTimeout(soTimeout);
        if (proxyUrl != null) {
            builder.setProxy(HttpHost.create((String)proxyUrl.trim()));
        }
        connector.config = builder.build();
        connector.httpClient = HttpClients.custom().setDefaultRequestConfig(connector.config).setConnectionManager((HttpClientConnectionManager)connector.pool).build();
        return connector;
    }

    public String post(String url, Map<String, String> param) {
        HttpPost httpPost = new HttpPost(url);
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(Connector.convertMapToPair(param), Consts.UTF_8));
        return this.doExecute((HttpRequestBase)httpPost, Consts.UTF_8.toString());
    }

    public String post(String url, Map<String, String> param, byte[] body) {
        HttpPost httpPost = new HttpPost(url);
        MultipartEntityBuilder reqEntity = MultipartEntityBuilder.create();
        reqEntity.addPart("content", (ContentBody)new ByteArrayBody(body, ContentType.DEFAULT_BINARY, param.get("slice_id")));
        for (Map.Entry<String, String> entry : param.entrySet()) {
            StringBody value = new StringBody(entry.getValue(), ContentType.create((String)"text/plain", (Charset)Consts.UTF_8));
            reqEntity.addPart(entry.getKey(), (ContentBody)value);
        }
        HttpEntity httpEntry = reqEntity.build();
        httpPost.setEntity(httpEntry);
        return this.doExecute((HttpRequestBase)httpPost, Consts.UTF_8.toString());
    }

    private String doExecute(HttpRequestBase requestBase, String charset) {
        String result;
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)requestBase);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                LOGGER.warn((Object)("request lfasr: " + requestBase.getURI() + ", status: " + statusCode));
                throw new LfasrException("{\"ok\":\"-1\", \"errNo\":\"26005\", \"failed\":\"HTTP\u8bf7\u6c42\u5931\u8d25!\", \"data\":\"\"}");
            }
            result = charset == null ? EntityUtils.toString((HttpEntity)response.getEntity()) : EntityUtils.toString((HttpEntity)response.getEntity(), (String)charset);
        }
        catch (IOException e) {
            LOGGER.warn((Object)("request lfasr: " + requestBase.getURI() + ", " + e.getMessage()));
            throw new LfasrException("{\"ok\":\"-1\", \"errNo\":\"26005\", \"failed\":\"HTTP\u8bf7\u6c42\u5931\u8d25!\", \"data\":\"\"}");
        }
        return result;
    }

    private static List<NameValuePair> convertMapToPair(Map<String, String> params) {
        ArrayList<NameValuePair> pairs = new ArrayList<NameValuePair>();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            pairs.add((NameValuePair)new BasicNameValuePair(entry.getKey(), entry.getValue()));
        }
        return pairs;
    }

    private static class ConnectorBuilder {
        private static Connector connector = new Connector();

        private ConnectorBuilder() {
        }
    }
}

