/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.msp.lfasr.process;

import com.alibaba.fastjson.JSON;
import com.iflytek.msp.lfasr.connect.Connector;
import com.iflytek.msp.lfasr.exception.LfasrException;
import com.iflytek.msp.lfasr.model.Message;
import com.iflytek.msp.lfasr.process.task.Task;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;

public class Processor {
    private static final Logger LOGGER = Logger.getLogger(Processor.class);
    private ExecutorService executor;
    private Connector connector;
    private int thresholdTimeout = 60000;

    private Processor() {
    }

    public static Processor build(int coreThreads, int maxThreads, int maxConnections, int connTimeout, int soTimeout, String proxyUrl) {
        Processor processor = ProcessorBuilder.processor;
        processor.executor = new ThreadPoolExecutor(coreThreads, maxThreads, 5L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>());
        processor.connector = Connector.build(maxConnections, connTimeout, soTimeout, proxyUrl);
        processor.thresholdTimeout = connTimeout + soTimeout + 10000;
        return processor;
    }

    public Message exec(Task task) {
        task.setConnector(this.connector);
        Future<Message> future = this.executor.submit(task);
        return this.getFutureAndRetry(future, task);
    }

    public Future<Message> submit(Task task) {
        task.setConnector(this.connector);
        return this.executor.submit(task);
    }

    public void exec(List<Task> taskList) {
        HashMap<Task, Future<Message>> futures = new HashMap<Task, Future<Message>>(taskList.size());
        for (Task task : taskList) {
            task.setConnector(this.connector);
            Future<Message> future = this.executor.submit(task);
            futures.put(task, future);
        }
        for (Map.Entry entry : futures.entrySet()) {
            this.getFutureAndRetry((Future)entry.getValue(), (Task)entry.getKey());
        }
    }

    private Message getFutureAndRetry(Future<Message> future, Task task) {
        Message message;
        try {
            message = future.get(this.thresholdTimeout, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException | TimeoutException e) {
            LOGGER.warn((Object)(task.getIntro() + ", " + e.getMessage()));
            message = (Message)JSON.parseObject((String)"{\"ok\":\"-1\", \"errNo\":\"26000\", \"failed\":\"\u8f6c\u5199sdk\u901a\u7528\u9519\u8bef!\", \"data\":\"\"}", Message.class);
            message = this.retry(task, message);
        }
        catch (InterruptedException e) {
            LOGGER.warn((Object)(task.getIntro() + ", " + e.getMessage()));
            message = (Message)JSON.parseObject((String)"{\"ok\":\"-1\", \"errNo\":\"26000\", \"failed\":\"\u8f6c\u5199sdk\u901a\u7528\u9519\u8bef!\", \"data\":\"\"}", Message.class);
            message = this.retry(task, message);
            Thread.currentThread().interrupt();
        }
        if (message.getOk() == 1) {
            message = this.retry(task, message);
        }
        return message;
    }

    private Message retry(Task task, Message message) {
        int retryCnt = task.getRetryCnt();
        if (++retryCnt > 3) {
            LOGGER.error((Object)(task.getIntro() + ", failed"));
            message.setOk(-1);
            throw new LfasrException(message.toString());
        }
        try {
            TimeUnit.SECONDS.sleep(1L);
        }
        catch (InterruptedException e) {
            LOGGER.warn((Object)e.getMessage());
            Thread.currentThread().interrupt();
        }
        task.setRetryCnt(retryCnt);
        return this.exec(task);
    }

    private static class ProcessorBuilder {
        private static Processor processor = new Processor();

        private ProcessorBuilder() {
        }
    }
}

