/*
 * Decompiled with CFR 0.152.
 */
package com.jumipm.utils;

import com.kotelmems.platform.exception.BaseException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CryptHelper {
    public static Log log = LogFactory.getLog(CryptHelper.class);
    public static final int AES_KEY_SIZE = 128;
    public static final int DES_KEY_SIZE = 56;
    public static final int ENCRYPT_MODE = 1;
    public static final int DECRYPT_MODE = 2;
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final String MD5 = "MD5";
    public static final String SHA = "SHA";
    public static final String AES = "AES";
    public static final String DES = "DES";
    private static final String SEC_RAN_ALG = "SHA1PRNG";

    public static final String bytes2HexStr(byte[] bytes) {
        return CryptHelper.bytes2HexStr(bytes, false);
    }

    public static final String bytes2HexStr(byte[] bytes, boolean capital) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(CryptHelper.byte2Hex(b, capital));
        }
        return sb.toString();
    }

    public static final char[] byte2Hex(byte b) {
        return CryptHelper.byte2Hex(b, false);
    }

    public static final char[] byte2Hex(byte b, boolean capital) {
        byte bh = (byte)(b >>> 4 & 0xF);
        byte bl = (byte)(b & 0xF);
        return new char[]{CryptHelper.halfByte2Hex(bh, capital), CryptHelper.halfByte2Hex(bl, capital)};
    }

    public static final char halfByte2Hex(byte b) {
        return CryptHelper.halfByte2Hex(b, false);
    }

    public static final char halfByte2Hex(byte b, boolean capital) {
        return (char)(b <= 9 ? b + 48 : (capital ? b + 65 - 10 : b + 97 - 10));
    }

    public static final byte[] hexStr2Bytes(String str) {
        int length = str.length();
        if (length % 2 != 0) {
            str = "0" + str;
            length = str.length();
        }
        byte[] bytes = new byte[length / 2];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = CryptHelper.hex2Byte(str.charAt(2 * i), str.charAt(2 * i + 1));
        }
        return bytes;
    }

    public static final byte hex2Byte(char ch, char cl) {
        byte bh = CryptHelper.hex2HalfByte(ch);
        byte bl = CryptHelper.hex2HalfByte(cl);
        return (byte)((bh << 4) + bl);
    }

    public static final byte hex2HalfByte(char c) {
        return (byte)(c <= '9' ? c - 48 : (c <= 'F' ? c - 65 + 10 : c - 97 + 10));
    }

    public static final String md5(String input) {
        return CryptHelper.md5(input, null);
    }

    public static final String md5(String input, String charset) {
        return CryptHelper.encode(CryptHelper.getMd5Digest(), input, charset);
    }

    public static final byte[] md5(byte[] input) {
        MessageDigest algorithm = CryptHelper.getMd5Digest();
        return CryptHelper.encode(algorithm, input);
    }

    public static final String sha(String input) {
        return CryptHelper.sha(input, null);
    }

    public static final String sha(String input, String charset) {
        return CryptHelper.encode(CryptHelper.getShaDigest(), input, charset);
    }

    public static final String sha(String input, int version) {
        return CryptHelper.sha(input, null, version);
    }

    public static final String sha(String input, String charset, int version) {
        return CryptHelper.encode(CryptHelper.getShaDigest(version), input, charset);
    }

    public static final byte[] sha(byte[] input) {
        MessageDigest algorithm = CryptHelper.getShaDigest();
        return CryptHelper.encode(algorithm, input);
    }

    public static final byte[] sha(byte[] input, int version) {
        MessageDigest algorithm = CryptHelper.getShaDigest(version);
        return CryptHelper.encode(algorithm, input);
    }

    public static final String encode(MessageDigest algorithm, String input) {
        return CryptHelper.encode(algorithm, input, null);
    }

    public static final String encode(MessageDigest algorithm, String input, String charset) {
        try {
            byte[] bytes = input.getBytes(CryptHelper.safeCharset(charset));
            byte[] output = CryptHelper.encode(algorithm, bytes);
            return CryptHelper.bytes2HexStr(output);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static final byte[] encode(MessageDigest algorithm, byte[] input) {
        return algorithm.digest(input);
    }

    public static final MessageDigest getMd5Digest() {
        return CryptHelper.getDigest(MD5);
    }

    public static final MessageDigest getShaDigest() {
        return CryptHelper.getDigest(SHA);
    }

    public static final MessageDigest getShaDigest(int version) {
        String algorithm = String.format("%s-%d", SHA, version);
        return CryptHelper.getDigest(algorithm);
    }

    public static final MessageDigest getDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static final MessageDigest getDigest(String algorithm, String provider) {
        try {
            return MessageDigest.getInstance(algorithm, provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchProviderException e) {
            throw new RuntimeException(e);
        }
    }

    public static final MessageDigest getDigest(String algorithm, Provider provider) {
        try {
            return MessageDigest.getInstance(algorithm, provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static final String urlEncode(String url) {
        return CryptHelper.urlEncode(url, null);
    }

    public static final String urlEncode(String url, String charset) {
        try {
            return URLEncoder.encode(url, CryptHelper.safeCharset(charset));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static final String urlDecode(String url) {
        return CryptHelper.urlDecode(url, null);
    }

    public static final String urlDecode(String url, String enc) {
        try {
            return URLDecoder.decode(url, CryptHelper.safeCharset(enc));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static final String aesEncrypt(String content, String password) throws GeneralSecurityException {
        return CryptHelper.aesEncrypt(content, null, password);
    }

    public static final String aesEncrypt(String content, String charset, String password) throws GeneralSecurityException {
        return CryptHelper.encrypt(AES, 128, content, charset, password);
    }

    public static final byte[] aesEncrypt(byte[] content, String password) throws GeneralSecurityException {
        return CryptHelper.crypt(AES, 1, 128, content, password);
    }

    public static final String aesDecrypt(String content, String password) throws GeneralSecurityException {
        return CryptHelper.aesDecrypt(content, null, password);
    }

    public static final String aesDecrypt(String content, String charset, String password) throws GeneralSecurityException {
        return CryptHelper.decrypt(AES, 128, content, charset, password);
    }

    public static final byte[] aesDecrypt(byte[] content, String password) throws GeneralSecurityException {
        return CryptHelper.crypt(AES, 2, 128, content, password);
    }

    public static final String desEncrypt(String content, String password) throws GeneralSecurityException {
        return CryptHelper.desEncrypt(content, null, password);
    }

    public static final String desEncrypt(String content, String charset, String password) throws GeneralSecurityException {
        return CryptHelper.encrypt(DES, 56, content, charset, password);
    }

    public static final byte[] desEncrypt(byte[] content, String password) throws GeneralSecurityException {
        return CryptHelper.crypt(DES, 1, 56, content, password);
    }

    public static final String desDecrypt(String content, String password) throws GeneralSecurityException {
        return CryptHelper.desDecrypt(content, null, password);
    }

    public static final String desDecrypt(String content, String charset, String password) throws GeneralSecurityException {
        return CryptHelper.decrypt(DES, 56, content, charset, password);
    }

    public static final byte[] desDecrypt(byte[] content, String password) throws GeneralSecurityException {
        return CryptHelper.crypt(DES, 2, 56, content, password);
    }

    public static final String encrypt(String method, int keysize, String content, String charset, String password) throws GeneralSecurityException {
        try {
            byte[] bytes = content.getBytes(CryptHelper.safeCharset(charset));
            byte[] output = CryptHelper.crypt(method, 1, keysize, bytes, password);
            return CryptHelper.bytes2HexStr(output);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static final String decrypt(String method, int keysize, String content, String charset, String password) throws GeneralSecurityException {
        try {
            byte[] bytes = CryptHelper.hexStr2Bytes(content);
            byte[] output = CryptHelper.crypt(method, 2, keysize, bytes, password);
            return new String(output, CryptHelper.safeCharset(charset));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static final byte[] crypt(String method, int mode, int keysize, byte[] content, String password) throws GeneralSecurityException {
        KeyGenerator kgen = KeyGenerator.getInstance(method);
        SecureRandom secure = SecureRandom.getInstance(SEC_RAN_ALG);
        String seed = StringUtils.isBlank((String)password) ? "" : password;
        secure.setSeed(seed.getBytes());
        kgen.init(keysize, secure);
        SecretKey secretKey = kgen.generateKey();
        byte[] enCodeFormat = secretKey.getEncoded();
        SecretKeySpec key = new SecretKeySpec(enCodeFormat, method);
        Cipher cipher = Cipher.getInstance(method);
        cipher.init(mode, key);
        return cipher.doFinal(content);
    }

    private static final String safeCharset(String charset) {
        if (StringUtils.isBlank((String)charset)) {
            charset = DEFAULT_ENCODING;
        }
        return charset;
    }

    public static String pwdEncry(String pwd) {
        try {
            String enPwd = CryptHelper.encrypt(AES, 128, pwd, DEFAULT_ENCODING, "");
            return enPwd;
        }
        catch (GeneralSecurityException e) {
            throw new BaseException("Crypthelper pwdEncry error", e);
        }
    }

    public static String pwdDecrypt(String encryPwd) {
        try {
            String enPwd = CryptHelper.decrypt(AES, 128, encryPwd, DEFAULT_ENCODING, "");
            return enPwd;
        }
        catch (GeneralSecurityException e) {
            throw new BaseException("Crypthelper pwdDecrypt error", e);
        }
    }

    public static void main(String[] args) {
        try {
            String pwd = CryptHelper.encrypt(AES, 128, "mtgpmp@2019", DEFAULT_ENCODING, "jmkj@666");
            log.debug((Object)("pwd--------->" + pwd));
            String unpwd = CryptHelper.decrypt(AES, 128, pwd, DEFAULT_ENCODING, "jmkj@666");
            log.debug((Object)("unpwd--------->" + unpwd));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

