/*
 * Decompiled with CFR 0.152.
 */
package com.jumipm.utils;

import com.jumipm.utils.ExchangeClient;
import com.jumipm.utils.MailConfigInfo;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import org.springframework.core.io.Resource;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;

public class MailUtil {
    public static JavaMailSenderImpl mailSender = MailUtil.createMailSender(MailConfigInfo.mail_host, MailConfigInfo.mail_port, MailConfigInfo.mail_username, MailConfigInfo.mail_password, MailConfigInfo.mail_smtp_timeout);
    public static String mailFrom = MailConfigInfo.mail_from;

    private static JavaMailSenderImpl createMailSender(String host, int port, String username, String password, int timeout) {
        JavaMailSenderImpl sender = new JavaMailSenderImpl();
        sender.setHost(host);
        sender.setPort(port);
        sender.setUsername(username);
        sender.setPassword(password);
        sender.setDefaultEncoding("Utf-8");
        Properties p = new Properties();
        p.setProperty("mail.smtp.timeout", timeout + "");
        p.setProperty("mail.smtp.auth", "true");
        if (465 == port) {
            p.setProperty("mail.smtp.ssl.enable", "true");
            p.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            p.setProperty("mail.smtp.socketFactory.fallback", "false");
            p.setProperty("mail.smtp.socketFactory.port", port + "");
        }
        sender.setJavaMailProperties(p);
        return sender;
    }

    public static void sendMailForTest(String host, int port, String username, String password, String from, String to) {
        SimpleMailMessage mail = new SimpleMailMessage();
        mail.setFrom(from);
        mail.setTo(to);
        mail.setSubject("\u90ae\u4ef6\u914d\u7f6e\u6d4b\u8bd5");
        mail.setSentDate(new Date());
        mail.setText("\u8fd9\u662f\u4e00\u7ad9\u5f0f\u9879\u76ee\u7ba1\u7406\u670d\u52a1\u5e73\u53f0\uff08XPM+\uff09\u90ae\u4ef6\u914d\u7f6e\u9875\u9762\u53d1\u9001\u7684\u6d4b\u8bd5\u90ae\u4ef6\uff0c\u5982\u60a8\u6536\u5230\uff0c\u8868\u793a\u90ae\u4ef6\u670d\u52a1\u5668\u914d\u7f6e\u6b63\u786e\u3002");
        JavaMailSenderImpl sender = MailUtil.createMailSender(host, port, username, password, 80000);
        sender.send(mail);
    }

    public static void sendExchangeMail(String serverHost, String username, String password, String to, String subject, String message, String domain, List<String> recipientTos, List<String> recipientCc) {
        if (null == recipientCc || recipientCc.size() == 0) {
            ExchangeClient client = new ExchangeClient.ExchangeClientBuilder().hostname(serverHost).exchangeVersion(ExchangeVersion.Exchange2010).username(username).password(password).domain(domain).recipientTos(recipientTos).subject(subject).message(message).build();
            client.sendExchange();
        } else {
            ExchangeClient client = new ExchangeClient.ExchangeClientBuilder().hostname(serverHost).exchangeVersion(ExchangeVersion.Exchange2010).username(username).password(password).domain(domain).recipientTos(recipientTos).recipientCc(recipientCc).subject(subject).message(message).build();
            client.sendExchange();
        }
    }

    public static void sendTextMail(String to, String subject, String text) {
        SimpleMailMessage mail = new SimpleMailMessage();
        mail.setFrom(mailFrom);
        mail.setTo(to);
        mail.setSubject(subject);
        mail.setSentDate(new Date());
        mail.setText(text);
        mailSender.send(mail);
    }

    public static void sendHtmlMail(String to, String subject, String html) throws MessagingException {
        MimeMessage mimeMessage = mailSender.createMimeMessage();
        MimeMessageHelper messageHelper = new MimeMessageHelper(mimeMessage, true, "UTF-8");
        messageHelper.setFrom(mailFrom);
        messageHelper.setTo(to);
        messageHelper.setSubject(subject);
        messageHelper.setText(html, true);
        mailSender.send(mimeMessage);
    }

    public static void sendFileMail(String to, String subject, String html, String contentId, Resource resource) throws MessagingException {
        MimeMessage mimeMessage = mailSender.createMimeMessage();
        MimeMessageHelper messageHelper = new MimeMessageHelper(mimeMessage, true, "UTF-8");
        messageHelper.setFrom(mailFrom);
        messageHelper.setTo(to);
        messageHelper.setSubject(subject);
        messageHelper.setText(html, true);
        messageHelper.addInline(contentId, resource);
        mailSender.send(mimeMessage);
    }
}

