/*
 * Decompiled with CFR 0.152.
 */
package com.kotelmems.platform.enumerable.loader;

import com.kotelmems.platform.enumerable.EnumItem;
import com.kotelmems.platform.enumerable.loader.EnumLoader;
import com.kotelmems.platform.enumerable.loader.JavaEnumLoader;
import com.kotelmems.platform.enumerable.loader.XmlEnumLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.core.io.Resource;

public class DefaultEnumLoader
implements EnumLoader {
    private Resource[] xmlClassPath;
    private String[] packageToScan;
    private EnumLoader[] enumLoaders;

    public void setXmlClassPath(Resource ... xmlClassPath) {
        this.xmlClassPath = xmlClassPath;
    }

    public void setPackageToScan(String ... packageToScan) {
        this.packageToScan = packageToScan;
    }

    public void setEnumLoaders(EnumLoader ... enumLoaders) {
        this.enumLoaders = enumLoaders;
    }

    @Override
    public Map<String, List<EnumItem>> load() {
        List<EnumLoader> loaders = this.getLoaders();
        HashMap<String, List<EnumItem>> result = new HashMap<String, List<EnumItem>>();
        for (EnumLoader loader : loaders) {
            Map<String, List<EnumItem>> temp = loader.load();
            for (String key : temp.keySet()) {
                if (result.containsKey(key)) {
                    ((List)result.get(key)).addAll((Collection)temp.get(key));
                    continue;
                }
                result.put(key, temp.get(key));
            }
        }
        return result;
    }

    private List<EnumLoader> getLoaders() {
        ArrayList<EnumLoader> loaders = new ArrayList<EnumLoader>();
        if (this.xmlClassPath != null) {
            loaders.add(new XmlEnumLoader(this.xmlClassPath));
        }
        if (this.packageToScan != null) {
            loaders.add(new JavaEnumLoader(this.packageToScan));
        }
        if (this.enumLoaders != null) {
            loaders.addAll(Arrays.asList(this.enumLoaders));
        }
        return loaders;
    }
}

