/*
 * Decompiled with CFR 0.152.
 */
package com.kotelmems.platform.jdbc.sql;

import com.kotelmems.platform.jdbc.sql.ParameterRecognizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class SqlPlan {
    String jdbcsql;
    NamedParameterMeta meta;

    public SqlPlan(String nameSql) {
        Map<Integer, String> nameDescription = ParameterRecognizer.parse(nameSql);
        StringBuffer buffer = new StringBuffer();
        int start = 0;
        for (Map.Entry<Integer, String> entry : nameDescription.entrySet()) {
            Integer end = entry.getKey();
            String name = entry.getValue();
            buffer.append(nameSql.substring(start, end));
            buffer.append("?");
            start = end + name.length() + 1;
        }
        buffer.append(nameSql.substring(start, nameSql.length()));
        this.jdbcsql = buffer.toString();
        this.meta = new NamedParameterMeta(nameDescription);
    }

    public String getPlanSql() {
        return this.jdbcsql;
    }

    public List<String> getNameList() {
        return this.meta.getNameList();
    }

    public Object[] getParameterList(Map<String, Object> args) {
        if (args == null) {
            return new Object[0];
        }
        List<String> namedList = this.getNameList();
        Object[] argsTemp = new Object[namedList.size()];
        for (int i = 0; i < namedList.size(); ++i) {
            String named = namedList.get(i);
            argsTemp[i] = args.get(named);
        }
        return argsTemp;
    }

    public static class NamedParameterMeta {
        private List<String> nameList = new ArrayList<String>();

        public NamedParameterMeta(Map<Integer, String> nameDescription) {
            Object[] nameAry = nameDescription.keySet().toArray();
            Arrays.sort(nameAry);
            for (int i = 0; i < nameAry.length; ++i) {
                this.nameList.add(nameDescription.get(nameAry[i]));
            }
        }

        public List<String> getNameList() {
            return this.nameList;
        }
    }
}

