/*
 * Decompiled with CFR 0.152.
 */
package com.jumipm.license.service;

import com.jumipm.common.utils.LicenseVerifyCore;
import com.jumipm.common.utils.RSADecryptUtil;
import com.jumipm.license.user.XpmUserDataJdbc;
import com.jumipm.utils.StrUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class LicenseInfo {
    private String key = "";
    private String msage = "";
    private String msage_ = "";
    private String data = "";
    private String count = "";
    private int warningMinDays = 7;
    private String warningmsg = "";

    public LicenseInfo() {
        this.setParam();
    }

    public void setParam() {
        try {
            Properties prop = new Properties();
            InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("verifyparam.properties");
            prop.load(in);
            this.key = prop.getProperty("license.key");
            this.msage = prop.getProperty("license.msg");
            try {
                this.warningMinDays = Integer.valueOf(prop.getProperty("license.expiration_days"));
            }
            catch (Exception e) {
                this.warningMinDays = 7;
            }
            this.msage_ = RSADecryptUtil.decrypt(this.msage, this.key);
            this.data = this.msage_.split("\\|\\|")[0];
            this.count = this.msage_.split("\\|\\|")[1];
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected boolean verify() {
        if (this.msage_.isEmpty() || this.data.isEmpty() || this.count.isEmpty()) {
            return false;
        }
        if (!"0000-00-00".equals(this.data)) {
            int days = LicenseVerifyCore.getValidityPeriod(this.data);
            if (0 <= days && days <= this.warningMinDays) {
                this.warningmsg = "verifyparam\u6587\u4ef6\u6709\u6548\u671f\u8fd8\u5269" + days + "\u5929\u5c31\u5230\u671f\u4e86\u8bf7\u83b7\u53d6\u65b0\u7684\u6587\u4ef6";
            }
            if (days < 0) {
                return false;
            }
        }
        if (Integer.valueOf(this.count) > 0) {
            Integer usercount = XpmUserDataJdbc.getUserCount();
            if (null == usercount) {
                return false;
            }
            if (Integer.valueOf(this.count) < usercount) {
                return false;
            }
        }
        return true;
    }

    public String getKey() {
        return this.key;
    }

    protected String getData() {
        if (StrUtil.isNull(this.data) || "0000-00-00".equals(this.data)) {
            return null;
        }
        return this.data;
    }

    protected String getCount() {
        if (StrUtil.isNull(this.count) || 0 >= Integer.valueOf(this.count)) {
            return null;
        }
        return this.count;
    }

    protected String getWarningmsg() {
        return this.warningmsg;
    }
}

