/*
 * Decompiled with CFR 0.152.
 */
package com.kotelmems.platform.email;

import com.kotelmems.platform.email.EmailInfo;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.HashMap;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.springframework.core.task.TaskExecutor;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;

@Service
public class MailSender {
    private JavaMailSender javaMailSender;
    private SimpleMailMessage simpleMailMessage;
    private FreeMarkerConfigurer freeMarkerConfigurer;
    private TaskExecutor taskExecutor;

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void setFreeMarkerConfigurer(FreeMarkerConfigurer freeMarkerConfigurer) {
        this.freeMarkerConfigurer = freeMarkerConfigurer;
    }

    public void setJavaMailSender(JavaMailSender javaMailSender) {
        this.javaMailSender = javaMailSender;
    }

    public void setSimpleMailMessage(SimpleMailMessage simpleMailMessage) {
        this.simpleMailMessage = simpleMailMessage;
    }

    public void send(EmailInfo emailInfo) {
        String to = emailInfo.getToEmail();
        String text = "";
        HashMap<String, EmailInfo> map = new HashMap<String, EmailInfo>(1);
        map.put("emailInfo", emailInfo);
        try {
            Template template = this.freeMarkerConfigurer.getConfiguration().getTemplate(emailInfo.getEmailTemplate());
            text = FreeMarkerTemplateUtils.processTemplateIntoString((Template)template, map);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
        this.taskExecutor.execute((Runnable)new SendMailThread(to, null, text));
    }

    public void sendMail(String to, String subject, String content) {
        try {
            MimeMessage message = this.javaMailSender.createMimeMessage();
            MimeMessageHelper messageHelper = new MimeMessageHelper(message, true, "utf-8");
            messageHelper.setFrom(this.simpleMailMessage.getFrom());
            if (subject != null) {
                messageHelper.setSubject(subject);
            } else {
                messageHelper.setSubject(this.simpleMailMessage.getSubject());
            }
            messageHelper.setTo(to);
            messageHelper.setText(content, true);
            this.javaMailSender.send(message);
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
    }

    private class SendMailThread
    implements Runnable {
        private String to;
        private String subject;
        private String content;

        private SendMailThread(String to, String subject, String content) {
            this.to = to;
            this.subject = subject;
            this.content = content;
        }

        @Override
        public void run() {
            MailSender.this.sendMail(this.to, this.subject, this.content);
        }
    }
}

