/*
 * Decompiled with CFR 0.152.
 */
package com.kotelmems.platform.jdbc.sql;

import java.util.LinkedHashMap;
import java.util.Map;

public class ParameterRecognizer {
    public static final String SQL_SEPARATORS = " \n\r\f\t,()=<>&|+-=/*'^![]#~\\";
    public static final char POS_SIGN = ':';

    public static Map<Integer, String> parse(String nameSql) {
        LinkedHashMap<Integer, String> parameterMeta = new LinkedHashMap<Integer, String>();
        int stringLength = nameSql.length();
        boolean inQuote = false;
        for (int indx = 0; indx < stringLength; ++indx) {
            char c = nameSql.charAt(indx);
            if (inQuote) {
                if ('\'' != c) continue;
                inQuote = false;
                continue;
            }
            if ('\'' == c) {
                inQuote = true;
                continue;
            }
            if (c != ':') continue;
            int right = ParameterRecognizer.firstIndexOfChar(nameSql, SQL_SEPARATORS, indx + 1);
            int chopLocation = right < 0 ? nameSql.length() : right;
            String param = nameSql.substring(indx + 1, chopLocation);
            if (ParameterRecognizer.isEmpty(param)) {
                throw new RuntimeException("Space is not allowed after parameter prefix ':' [" + nameSql + "]");
            }
            parameterMeta.put(indx++, param);
            indx = chopLocation - 1;
        }
        return parameterMeta;
    }

    private static int firstIndexOfChar(String sqlString, String string, int startindex) {
        int matchAt = -1;
        for (int i = 0; i < string.length(); ++i) {
            int curMatch = sqlString.indexOf(string.charAt(i), startindex);
            if (curMatch < 0) continue;
            matchAt = matchAt == -1 ? curMatch : Math.min(matchAt, curMatch);
        }
        return matchAt;
    }

    private static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }
}

