/*
 * Decompiled with CFR 0.152.
 */
package com.kotelmems.platform.page;

import com.kotelmems.platform.page.PageRequest;
import com.kotelmems.platform.page.PageUtils;
import java.io.Serializable;
import java.util.List;

public class PageResponse
implements Serializable {
    protected int pageSize;
    protected int pageNumber;
    protected int totalCount = 0;
    private String sortColumns;

    public PageResponse() {
    }

    public PageResponse(PageRequest p, int totalCount) {
        this(p.getPageNumber(), p.getPageSize(), totalCount, p.getSortColumns());
    }

    public PageResponse(int pageNumber, int pageSize, int totalCount, String sortColumns) {
        if (pageSize <= 0) {
            throw new IllegalArgumentException("[pageSize] must great than zero");
        }
        this.pageSize = pageSize;
        this.pageNumber = PageUtils.computePageNumber(pageNumber, pageSize, totalCount);
        this.totalCount = totalCount;
        this.sortColumns = sortColumns;
    }

    public String getSortColumns() {
        return this.sortColumns;
    }

    public void setSortColumns(String sortColumns) {
        this.sortColumns = sortColumns;
    }

    public boolean isFirstPage() {
        return this.getThisPageNumber() == 1;
    }

    public boolean isLastPage() {
        return this.getThisPageNumber() >= this.getLastPageNumber();
    }

    public boolean isHasNextPage() {
        return this.getLastPageNumber() > this.getThisPageNumber();
    }

    public boolean isHasPreviousPage() {
        return this.getThisPageNumber() > 1;
    }

    public int getLastPageNumber() {
        return PageUtils.computeLastPageNumber(this.totalCount, this.pageSize);
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public int getThisPageFirstElementNumber() {
        return (this.getThisPageNumber() - 1) * this.getPageSize() + 1;
    }

    public int getThisPageLastElementNumber() {
        int fullPage = this.getThisPageFirstElementNumber() + this.getPageSize() - 1;
        return this.getTotalCount() < fullPage ? this.getTotalCount() : fullPage;
    }

    public int getNextPageNumber() {
        return this.getThisPageNumber() + 1;
    }

    public int getPreviousPageNumber() {
        return this.getThisPageNumber() - 1;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getThisPageNumber() {
        return this.pageNumber;
    }

    public List<Integer> getLinkPageNumbers() {
        return PageUtils.generateLinkPageNumbers(this.getThisPageNumber(), this.getLastPageNumber(), 10);
    }

    public int getFirstResult() {
        return PageUtils.getFirstResult(this.pageNumber, this.pageSize);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Page [pageSize=");
        builder.append(this.pageSize);
        builder.append(", pageNumber=");
        builder.append(this.pageNumber);
        builder.append(", totalCount=");
        builder.append(this.totalCount);
        builder.append("]");
        return builder.toString();
    }
}

