/*
 * Decompiled with CFR 0.152.
 */
package com.jumipm.common.page;

import com.jumipm.common.page.reslover.JumiPageRequestReslover;
import com.jumipm.common.page.reslover.impl.AgGridReslover;
import com.jumipm.common.page.reslover.impl.AppPageReslover;
import com.jumipm.common.page.reslover.impl.DataTableReslover;
import com.kotelmems.platform.page.PageRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class PageRequestMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    public static final String DATA_PAGE = "aoData";
    public static final String AG_GRID = "agData";
    public static final String APP_PAGE = "appPage";
    Map<String, JumiPageRequestReslover> reslovers;

    public PageRequestMethodArgumentResolver(Map<String, JumiPageRequestReslover> reslovers) {
        this.reslovers = reslovers;
    }

    public PageRequestMethodArgumentResolver() {
        this.reslovers = new HashMap<String, JumiPageRequestReslover>();
        this.reslovers.put(AG_GRID, new AgGridReslover());
        this.reslovers.put(DATA_PAGE, new DataTableReslover());
        this.reslovers.put(APP_PAGE, new AppPageReslover());
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.getParameterType().equals(PageRequest.class);
    }

    public JumiPageRequestReslover getReslover(String resolverType) {
        return this.reslovers.get(resolverType);
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        Map parms = webRequest.getParameterMap();
        String resloverType = "";
        if (parms.containsKey(DATA_PAGE)) {
            resloverType = DATA_PAGE;
        }
        if (parms.containsKey(AG_GRID)) {
            resloverType = AG_GRID;
        }
        if (parms.containsKey(APP_PAGE)) {
            resloverType = APP_PAGE;
        }
        if (!this.reslovers.containsKey(resloverType)) {
            return new PageRequest(1, 10);
        }
        String pageInfoR = ((String[])parms.get(resloverType))[0];
        return this.reslovers.get(resloverType).resolveArgument(pageInfoR);
    }
}

