/*
 * Decompiled with CFR 0.152.
 */
package com.jumipm.utils;

import com.jumipm.common.exception.BusinessException;
import com.jumipm.utils.Validation;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DateUtils {
    public static final String FORMAT_HH_MM = "HH:mm";
    public static final String FORMAT_MM_DD = "MM-dd";
    public static final String FORMAT_PARTEN_DATE = "yyyy-MM-dd";
    public static final String FORMAT_PARTEN_DATE_TIME = "yyyy-MM-dd HH:mm:ss";
    public static final String FORMAT_PARTEN_DATE_MINUTE = "yyyy-MM-dd HH:mm";
    public static final String T_FORMAT_PARTEN_DATE_TIME = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";
    public static final String FORMAT_EMD_TIME = "EEE MMM dd HH:mm:ss Z yyyy";
    private static Map<String, SimpleDateFormat> format = new ConcurrentHashMap<String, SimpleDateFormat>();

    public static SimpleDateFormat getFormat(String pattern) {
        return format.computeIfAbsent(pattern, k -> new SimpleDateFormat(pattern));
    }

    public static SimpleDateFormat getFormat(String pattern, Locale locale) {
        return format.computeIfAbsent(pattern + locale.toString(), k -> new SimpleDateFormat(pattern, locale));
    }

    public static String getDateTimeValue() {
        Date date = new Date();
        SimpleDateFormat sdf = DateUtils.getFormat(FORMAT_PARTEN_DATE_TIME);
        return sdf.format(date);
    }

    public static String getDateValue() {
        Date date = new Date();
        SimpleDateFormat sdf = DateUtils.getFormat("yyyyMMddHHmmss");
        return sdf.format(date);
    }

    public static String getTimeValue() {
        Date date = new Date();
        SimpleDateFormat sdf = DateUtils.getFormat("yyyyMMddHHmmssSSS");
        return sdf.format(date);
    }

    public static String getyyyyMMddDateValue() {
        Date date = new Date();
        SimpleDateFormat sdf = DateUtils.getFormat("yyyyMMdd");
        return sdf.format(date);
    }

    public static String getDateStrValue() {
        Date date = new Date();
        SimpleDateFormat sdf = DateUtils.getFormat("yyyy_MMdd_HHmm_ss");
        return sdf.format(date);
    }

    public static String formatDate(Date date) {
        if (null == date) {
            return "";
        }
        return DateUtils.getFormat(FORMAT_PARTEN_DATE).format(date);
    }

    public static String formatDateTime(Date date) {
        if (null == date) {
            return "";
        }
        return DateUtils.getFormat(FORMAT_PARTEN_DATE_TIME).format(date);
    }

    public static String format(String formatParten, Date date) {
        if (null == date) {
            return "";
        }
        return DateUtils.getFormat(formatParten).format(date);
    }

    public static Date formatToDate(String formatParten, Date date) {
        SimpleDateFormat format = DateUtils.getFormat(formatParten);
        try {
            return format.parse(format.format(date));
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String stringToString(String dateStr) {
        SimpleDateFormat dateFormat = DateUtils.getFormat(FORMAT_PARTEN_DATE);
        try {
            if (dateStr != null && !"".equals(dateStr)) {
                return dateFormat.format(dateFormat.parse(dateStr));
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Date timeStampToDate(String date) {
        if (date.equals("")) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Long.parseLong(date);
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(Long.parseLong(date));
        return c.getTime();
    }

    public static Date stringToDate(String dateStr) {
        SimpleDateFormat dateFormat = DateUtils.getFormat(FORMAT_PARTEN_DATE);
        try {
            if (dateStr != null && !"".equals(dateStr)) {
                return dateFormat.parse(dateStr);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Date stringToDateTime(String dateStr) {
        SimpleDateFormat dateFormat = DateUtils.getFormat(FORMAT_PARTEN_DATE_TIME);
        try {
            if (dateStr != null && !"".equals(dateStr)) {
                return dateFormat.parse(dateStr);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Date stringToDateMinute(String dateStr) {
        try {
            SimpleDateFormat dateFormat = DateUtils.getFormat(FORMAT_PARTEN_DATE_MINUTE);
            if (dateStr != null && !"".equals(dateStr)) {
                return dateFormat.parse(dateStr);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Calendar calendar() {
        Calendar cal = GregorianCalendar.getInstance(Locale.CHINESE);
        cal.setFirstDayOfWeek(2);
        return cal;
    }

    public static int getDaysCountByYearMonth(int year, int month) {
        Calendar cal = DateUtils.calendar();
        cal.set(year, month - 1, 1);
        int day = cal.getActualMaximum(5);
        return day;
    }

    public static int dayOfWeek(Date date) {
        Calendar cal = DateUtils.calendar();
        cal.setTime(date);
        int dayofweek = cal.get(7) - 1;
        return dayofweek == 0 ? 7 : dayofweek;
    }

    public static int dayOfMonth(Date date) {
        Calendar cal = DateUtils.calendar();
        cal.setTime(date);
        int dayofmonth = cal.get(5);
        return dayofmonth;
    }

    public static Date addDays(Date date, int calendarField, int amount) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(calendarField, amount);
        return c.getTime();
    }

    public static String toDate(String format, Date date) {
        if (Validation.isNULL(format).booleanValue()) {
            return DateUtils.getFormat(FORMAT_PARTEN_DATE_TIME).format(date);
        }
        return DateUtils.getFormat(format).format(date);
    }

    public static String addNoHours(String time, int no) {
        SimpleDateFormat dateFormat = DateUtils.getFormat(FORMAT_PARTEN_DATE_TIME);
        try {
            if (time != null && !"".equals(time)) {
                Date d = dateFormat.parse(time);
                long str = d.getTime();
                int i = 3600000 * no;
                return dateFormat.format(str += (long)i);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String reduceNoHours(String time, int no) {
        SimpleDateFormat dateFormat = DateUtils.getFormat(FORMAT_PARTEN_DATE_TIME);
        try {
            if (time != null && !"".equals(time)) {
                Date d = dateFormat.parse(time);
                long str = d.getTime();
                int i = 3600000 * no;
                return dateFormat.format(str -= (long)i);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean isNeedStatistics(String ny) {
        int year = Integer.valueOf(ny.split("-")[0]);
        int month = Integer.valueOf(ny.split("-")[1]);
        Calendar cal = DateUtils.calendar();
        int yearCut = cal.get(1);
        int monthCut = cal.get(2) + 1;
        if (year > yearCut) {
            return false;
        }
        if (year == yearCut) {
            return monthCut - month < 2;
        }
        return yearCut - year == 1 && month == 12 && monthCut == 1;
    }

    public static String dateToString(Date time) {
        if (time != null) {
            String dates = DateUtils.getFormat(FORMAT_PARTEN_DATE).format(time);
            return dates;
        }
        return null;
    }

    public static String dateTimeToString(Date time) {
        if (time != null) {
            String dates = DateUtils.getFormat(FORMAT_PARTEN_DATE_TIME).format(time);
            return dates;
        }
        return null;
    }

    public static int getWeekOfYear(Date date) {
        GregorianCalendar c = new GregorianCalendar();
        c.setFirstDayOfWeek(2);
        c.setMinimalDaysInFirstWeek(7);
        c.setTime(date);
        return c.get(3);
    }

    public static int getMaxWeekNumOfYear(int year) {
        GregorianCalendar c = new GregorianCalendar();
        c.set(year, 11, 31, 23, 59, 59);
        return DateUtils.getWeekOfYear(c.getTime());
    }

    public static Date getFirstDayOfWeek(Date date) {
        Calendar c = DateUtils.calendar();
        c.setFirstDayOfWeek(2);
        c.setTime(date);
        c.set(7, c.getFirstDayOfWeek());
        return c.getTime();
    }

    public static Date getLastDayOfWeek(Date date) {
        Calendar c = DateUtils.calendar();
        c.setFirstDayOfWeek(2);
        c.setTime(date);
        c.set(7, c.getFirstDayOfWeek() + 6);
        return c.getTime();
    }

    public static int getWeekOfDate(Date date) {
        Calendar c = DateUtils.calendar();
        c.setFirstDayOfWeek(2);
        c.setTime(date);
        return c.get(3);
    }

    public static String mStoString(Long dateMS) {
        SimpleDateFormat sdf = DateUtils.getFormat(FORMAT_PARTEN_DATE);
        return sdf.format(dateMS);
    }

    public static String getYearAndWeekDate(int year, int week) {
        String time = "[";
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.setFirstDayOfWeek(2);
        cal.set(1, year);
        cal.set(3, week);
        SimpleDateFormat sdf = DateUtils.getFormat(FORMAT_MM_DD);
        time = time + sdf.format(cal.getTime());
        time = time + "~";
        cal.set(7, 1);
        time = time + sdf.format(cal.getTime());
        time = time + "]";
        return time;
    }

    public static Map<String, Object> getDateByYearAndWeek(int year, int week) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        SimpleDateFormat sdf = DateUtils.getFormat(FORMAT_PARTEN_DATE);
        map.put("begin", sdf.format(DateUtils.getFirstDayOfWeek(year, week)));
        map.put("end", sdf.format(DateUtils.getLastDayOfWeek(year, week)));
        return map;
    }

    public static long calculateTimeByDate(Date beginDate) {
        long l = new Date().getTime() - beginDate.getTime();
        return l;
    }

    public static Integer calculateDaysByDate(Date beginDate, Date endDate) {
        long l = endDate.getTime() - beginDate.getTime();
        Integer days = new Long(l / 86400000L).intValue();
        return days;
    }

    public static Integer calculateDaysByString(String begin, String end) {
        SimpleDateFormat sdf = DateUtils.getFormat(FORMAT_PARTEN_DATE);
        try {
            Date beginDate = sdf.parse(begin);
            Date endDate = sdf.parse(end);
            return DateUtils.calculateDaysByDate(beginDate, endDate);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The date must not be null");
        }
    }

    public static int daysBetween(String smdateS, String bdateS) {
        if (smdateS == null || bdateS == null) {
            return 0;
        }
        SimpleDateFormat sdf = DateUtils.getFormat(FORMAT_PARTEN_DATE);
        Date smdate = null;
        Date bdate = null;
        try {
            smdate = sdf.parse(smdateS);
            bdate = sdf.parse(bdateS);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(smdate);
        long time1 = cal.getTimeInMillis();
        cal.setTime(bdate);
        long time2 = cal.getTimeInMillis();
        long between_days = (time2 - time1) / 86400000L;
        return Integer.parseInt(String.valueOf(between_days));
    }

    public static String getFirstDay_Month() {
        SimpleDateFormat format = DateUtils.getFormat(FORMAT_PARTEN_DATE);
        Calendar c = Calendar.getInstance();
        c.add(2, 0);
        c.set(5, 1);
        String first = format.format(c.getTime());
        return first;
    }

    public static String getFirstDay_Month(Date date) {
        SimpleDateFormat format = DateUtils.getFormat(FORMAT_PARTEN_DATE);
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(2, 0);
        c.set(5, 1);
        String first = format.format(c.getTime());
        return first;
    }

    public static String getLastDay_Month() {
        SimpleDateFormat format = DateUtils.getFormat(FORMAT_PARTEN_DATE);
        Calendar ca = Calendar.getInstance();
        ca.set(5, ca.getActualMaximum(5));
        String last = format.format(ca.getTime());
        return last;
    }

    public static String getLastDay_Month(Date date) {
        SimpleDateFormat format = DateUtils.getFormat(FORMAT_PARTEN_DATE);
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        ca.set(5, ca.getActualMaximum(5));
        String last = format.format(ca.getTime());
        return last;
    }

    public static int getYearStr() {
        Calendar c = Calendar.getInstance();
        return c.get(1);
    }

    public static String getLastDayOfMonthYear(Date date) {
        SimpleDateFormat format = DateUtils.getFormat(FORMAT_PARTEN_DATE);
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        ca.set(5, ca.getActualMaximum(5));
        String last = format.format(ca.getTime());
        return last;
    }

    public static String getSeason() {
        Calendar c = Calendar.getInstance();
        int month = c.get(2) + 1;
        if (month <= 3) {
            return "\u7b2c\u4e00\u5b63\u5ea6";
        }
        if (month <= 6) {
            return "\u7b2c\u4e8c\u5b63\u5ea6";
        }
        if (month <= 9) {
            return "\u7b2c\u4e09\u5b63\u5ea6";
        }
        return "\u7b2c\u56db\u5b63\u5ea6";
    }

    public static Map<String, Object> getWeekByYearAndWeek(int year, int week) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Calendar cal = DateUtils.calendar();
        cal.setFirstDayOfWeek(2);
        cal.set(1, year);
        cal.set(3, week);
        SimpleDateFormat sdf = DateUtils.getFormat(FORMAT_PARTEN_DATE);
        cal.set(7, 2);
        map.put("1", sdf.format(cal.getTime()));
        cal.set(7, 3);
        map.put("2", sdf.format(cal.getTime()));
        cal.set(7, 4);
        map.put("3", sdf.format(cal.getTime()));
        cal.set(7, 5);
        map.put("4", sdf.format(cal.getTime()));
        cal.set(7, 6);
        map.put("5", sdf.format(cal.getTime()));
        cal.set(7, 7);
        map.put("6", sdf.format(cal.getTime()));
        cal.set(7, 1);
        map.put("7", sdf.format(cal.getTime()));
        return map;
    }

    public static String getSeason(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int month = c.get(2) + 1;
        if (month <= 3) {
            return "\u7b2c\u4e00\u5b63\u5ea6";
        }
        if (month <= 6) {
            return "\u7b2c\u4e8c\u5b63\u5ea6";
        }
        if (month <= 9) {
            return "\u7b2c\u4e09\u5b63\u5ea6";
        }
        return "\u7b2c\u56db\u5b63\u5ea6";
    }

    public static String stringtoDate(String strDate, int n) {
        SimpleDateFormat sdf = DateUtils.getFormat(FORMAT_PARTEN_DATE);
        try {
            Date date = sdf.parse(strDate);
            Calendar c = DateUtils.calendar();
            c.setTime(date);
            return DateUtils.mStoString(c.getTimeInMillis() - (long)(n * 86400000));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int dateToWeek(Date date, int n) {
        try {
            Calendar c = DateUtils.calendar();
            c.setTime(date);
            String sd = DateUtils.mStoString(c.getTimeInMillis() - (long)(n * 7 * 86400000));
            return DateUtils.getWeekOfYear(DateUtils.stringToDate(sd));
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static int getMoth() {
        Calendar c = Calendar.getInstance();
        int month = c.get(2) + 1;
        return month;
    }

    public static String getDay(Date date) {
        String day = date.toString().split("-")[2];
        return day;
    }

    public static int getYear() {
        Calendar c = Calendar.getInstance();
        int year = c.get(1);
        return year;
    }

    public static int getMoth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int month = c.get(2) + 1;
        return month;
    }

    public static int getMothFirstDayAtWeek(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(2, 0);
        c.set(5, 1);
        return c.get(3);
    }

    public static int getYear(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int year = c.get(1);
        return year;
    }

    public static String getCurrentQuarterStartDay() {
        SimpleDateFormat format = DateUtils.getFormat(FORMAT_PARTEN_DATE);
        Calendar c = Calendar.getInstance();
        int currentMonth = c.get(2) + 1;
        try {
            if (currentMonth >= 1 && currentMonth <= 3) {
                c.set(2, 0);
            } else if (currentMonth >= 4 && currentMonth <= 6) {
                c.set(2, 3);
            } else if (currentMonth >= 7 && currentMonth <= 9) {
                c.set(2, 6);
            } else if (currentMonth >= 10 && currentMonth <= 12) {
                c.set(2, 9);
            }
            c.set(5, 1);
            String startDay = format.format(c.getTime());
            return startDay;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date parse(String str, String pattern, Locale locale) {
        if (str == null || pattern == null) {
            return null;
        }
        try {
            return DateUtils.getFormat(pattern, locale).parse(str);
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new BusinessException("\u65e5\u671f\u5b57\u7b26\u89e3\u6790\u5f02\u5e38====" + str);
        }
    }

    public static String format(Date date, String pattern, Locale locale) {
        if (date == null || pattern == null) {
            return null;
        }
        return DateUtils.getFormat(pattern, locale).format(date);
    }

    public static String getCurrentQuarterEndDay() {
        SimpleDateFormat format = DateUtils.getFormat(FORMAT_PARTEN_DATE);
        Calendar c = Calendar.getInstance();
        int currentMonth = c.get(2) + 1;
        try {
            if (currentMonth >= 1 && currentMonth <= 3) {
                c.set(2, 2);
                c.set(5, 31);
            } else if (currentMonth >= 4 && currentMonth <= 6) {
                c.set(2, 5);
                c.set(5, 30);
            } else if (currentMonth >= 7 && currentMonth <= 9) {
                c.set(2, 8);
                c.set(5, 30);
            } else if (currentMonth >= 10 && currentMonth <= 12) {
                c.set(2, 11);
                c.set(5, 31);
            }
            String endDay = format.format(c.getTime());
            return endDay;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date covertDateFromTDate(String oldDateStr) throws ParseException {
        SimpleDateFormat df = DateUtils.getFormat(T_FORMAT_PARTEN_DATE_TIME);
        Date date = df.parse(oldDateStr);
        SimpleDateFormat df1 = DateUtils.getFormat(FORMAT_EMD_TIME, Locale.UK);
        df1.parse(date.toString());
        df1.format(date);
        SimpleDateFormat df2 = DateUtils.getFormat(FORMAT_PARTEN_DATE_TIME);
        df2.parse(df2.format(date));
        return df2.parse(df2.format(date));
    }

    public static String getDateCode() {
        Date date = new Date();
        SimpleDateFormat sdf = DateUtils.getFormat("yyyyMMddHHmmssSSS");
        return sdf.format(date);
    }

    public static Date getBeginTime(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        int firstDay = cal.getActualMinimum(5);
        cal.set(5, firstDay);
        return cal.getTime();
    }

    public static Date getEndTime(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        int lastDay = cal.getActualMaximum(5);
        cal.set(5, lastDay);
        return cal.getTime();
    }

    public static List<String> getYearMonthArry(Date d, String separator) {
        int i;
        ArrayList<String> list = new ArrayList<String>();
        if (null == separator) {
            separator = "-";
        }
        Calendar date = Calendar.getInstance();
        date.setTime(d);
        int nYear = date.get(1);
        for (i = date.get(2) + 1; i > 0; --i) {
            list.add(nYear + separator + i);
        }
        if (list.size() < 12) {
            i = 12;
            while (list.size() < 12) {
                list.add(nYear - 1 + separator + i);
                --i;
            }
        }
        return list;
    }

    public static List<String> getMonthArry(Date d) {
        int nMonth;
        int i;
        ArrayList<String> list = new ArrayList<String>();
        Calendar date = Calendar.getInstance();
        date.setTime(d);
        for (i = nMonth = date.get(2) + 1; i > 0; --i) {
            list.add(i + "");
        }
        if (list.size() < 12) {
            i = 12;
            while (list.size() < 12) {
                list.add(i + "");
                --i;
            }
        }
        return list;
    }

    public static String plusDay(int num, Date date) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        ca.add(5, num);
        return DateUtils.getFormat(FORMAT_PARTEN_DATE).format(ca.getTime());
    }

    public static String addAndMinusYear(String date, String pattern, int year) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        Calendar rightNow = Calendar.getInstance();
        try {
            Date dt = sdf.parse(date);
            rightNow.setTime(dt);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        rightNow.add(1, year);
        if (year > 0) {
            rightNow.add(2, -1);
        } else {
            rightNow.add(2, 1);
        }
        Date dt1 = rightNow.getTime();
        String reStr = sdf.format(dt1);
        return reStr;
    }

    public static String addOneMonth(String date, String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        Calendar rightNow = Calendar.getInstance();
        try {
            Date dt = sdf.parse(date);
            rightNow.setTime(dt);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        rightNow.add(2, 1);
        Date dt1 = rightNow.getTime();
        String reStr = sdf.format(dt1);
        return reStr;
    }

    public static int calcMonthOffset(Date startTime, Date endTime) {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(startTime);
        c2.setTime(endTime);
        int c1Month = c1.get(2) + 1;
        int c2Month = c2.get(2) + 1;
        int c1Year = c1.get(1);
        int c2Year = c2.get(1);
        if (c1Year != c2Year) {
            return c2Month - c1Month + (c2Year - c1Year) * 12;
        }
        return c2Month - c1Month;
    }

    public static int calcWeekOffset(Date startTime, Date endTime) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(startTime);
        int dayOfWeek = cal.get(7);
        if (--dayOfWeek == 0) {
            dayOfWeek = 7;
        }
        int dayOffset = DateUtils.calcDayOffset(startTime, endTime);
        int weekOffset = dayOffset / 7;
        int a = dayOffset > 0 ? (dayOffset % 7 + dayOfWeek > 7 ? 1 : 0) : (dayOfWeek + dayOffset % 7 < 1 ? -1 : 0);
        return weekOffset += a;
    }

    public static int calcDayOffset(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        int day1 = cal1.get(6);
        int day2 = cal2.get(6);
        int year1 = cal1.get(1);
        int year2 = cal2.get(1);
        if (year1 != year2) {
            int timeDistance = 0;
            for (int i = year1; i < year2; ++i) {
                if (i % 4 == 0 && i % 100 != 0 || i % 400 == 0) {
                    timeDistance += 366;
                    continue;
                }
                timeDistance += 365;
            }
            return timeDistance + (day2 - day1);
        }
        return day2 - day1;
    }

    public static Date getFirstDayOfWeek(int year, int week) {
        GregorianCalendar c = new GregorianCalendar();
        c.set(1, year);
        c.set(2, 0);
        c.set(5, 1);
        GregorianCalendar cal = (GregorianCalendar)((Calendar)c).clone();
        ((Calendar)cal).add(5, week * 7);
        return DateUtils.getFirstDayOfWeek(cal.getTime());
    }

    public static Date getLastDayOfWeek(int year, int week) {
        GregorianCalendar c = new GregorianCalendar();
        c.set(1, year);
        c.set(2, 0);
        c.set(5, 1);
        GregorianCalendar cal = (GregorianCalendar)((Calendar)c).clone();
        ((Calendar)cal).add(5, week * 7);
        return DateUtils.getLastDayOfWeek(cal.getTime());
    }

    public static int getDayString(Date startDate) {
        int offSet = Calendar.getInstance().getTimeZone().getRawOffset();
        long today = (System.currentTimeMillis() + (long)offSet) / 86400000L;
        long start = (startDate.getTime() + (long)offSet) / 86400000L;
        return (int)(start - today);
    }

    public static String getStartOfDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int year = calendar.get(1);
        int month = calendar.get(2);
        int day = calendar.get(5);
        calendar.set(year, month, day, 0, 0, 0);
        SimpleDateFormat simpleDateFormat = DateUtils.getFormat(FORMAT_PARTEN_DATE_TIME);
        return simpleDateFormat.format(calendar.getTime());
    }

    public static String getEndOfDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int year = calendar.get(1);
        int month = calendar.get(2);
        int day = calendar.get(5);
        calendar.set(year, month, day, 23, 59, 59);
        SimpleDateFormat simpleDateFormat = DateUtils.getFormat(FORMAT_PARTEN_DATE_TIME);
        return simpleDateFormat.format(calendar.getTime());
    }

    public static Date localDateTime2Date(LocalDateTime localDateTime) {
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date localDate2Date(LocalDate localDate) {
        LocalDateTime startOfDay = localDate.atStartOfDay();
        return Date.from(startOfDay.atZone(ZoneId.systemDefault()).toInstant());
    }
}

