/*
 * Decompiled with CFR 0.152.
 */
package com.jumipm.utils;

import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringUtils
implements ApplicationContextAware {
    private static ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        SpringUtils.applicationContext = applicationContext;
    }

    public static <T> T getBean(String beanName) {
        if (applicationContext.containsBean(beanName)) {
            return (T)applicationContext.getBean(beanName);
        }
        return null;
    }

    public static <T> Map<String, T> getBeansOfType(Class<T> baseType) {
        return applicationContext.getBeansOfType(baseType);
    }

    public static <T> T getBeanByNameAndType(String beanName, Class<T> baseType) {
        Map beanMap = applicationContext.getBeansOfType(baseType);
        if (beanMap.containsKey(beanName)) {
            return (T)beanMap.get(beanName);
        }
        return null;
    }

    public static <T> T getBean(Class<T> c) {
        return (T)applicationContext.getBean(c);
    }
}

