/*
 * Decompiled with CFR 0.152.
 */
package com.jumipm.utils;

import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class StrUtil {
    public static boolean isNotNull(String str) {
        return !StrUtil.isNull(str);
    }

    public static boolean isNull(String str) {
        return StringUtils.isBlank((CharSequence)str) || str.equalsIgnoreCase("\"null\"") || str.equalsIgnoreCase("null");
    }

    public static boolean listIsNotNull(Collection<?> list) {
        return !StrUtil.listIsNull(list);
    }

    public static boolean listIsNull(Collection<?> list) {
        return null == list || list.isEmpty() || list.size() <= 0;
    }

    public static boolean objIsNotNull(Object obj) {
        return null != obj;
    }

    public static String objToString(Object obj) {
        if (null != obj) {
            return obj.toString();
        }
        return "";
    }

    public static boolean checkTypeByStrArry(String strArry, String type) {
        boolean b = false;
        if (null != type && StrUtil.isNotNull(strArry)) {
            HashSet<String> set = new HashSet<String>(Arrays.asList(strArry.split(",")));
            b = set.contains(type);
        }
        return b;
    }

    public static boolean checkContainByStrArry(String strArry, String type) {
        boolean b = false;
        if (null != type && StrUtil.isNotNull(strArry)) {
            String[] types = strArry.split(",");
            for (int i = 0; i < types.length; ++i) {
                if (!type.contains(types[i])) continue;
                b = true;
                break;
            }
        }
        return b;
    }

    public static String getCreateSearchStr(String sSearch) {
        if (StrUtil.isNotNull(sSearch)) {
            String[] arr = sSearch.split("");
            StringBuffer sb = new StringBuffer(sSearch.length() * 2);
            for (int i = 0; i < arr.length; ++i) {
                if ("".equals(arr[i])) continue;
                sb.append("%");
                sb.append(arr[i]);
            }
            sb.append("%");
            return sb.toString();
        }
        return sSearch;
    }

    public static String[] listToArray(List<String> list) {
        return list.toArray(new String[list.size()]);
    }

    public static Map<String, Object> listToMap(List<?> list, String keyColumn) {
        if (StrUtil.isNull(keyColumn)) {
            throw new IllegalArgumentException("\u5fc5\u987b\u6307\u5b9akey\u53c2\u6570\u5217");
        }
        HashMap<String, Object> r = new HashMap<String, Object>();
        if (StrUtil.listIsNotNull(list)) {
            for (int i = 0; i < list.size(); ++i) {
                JSONObject json;
                String key;
                Object obj = list.get(i);
                if (null == obj || StrUtil.isNull(key = (json = (JSONObject)JSONObject.toJSON(obj)).getString(keyColumn))) continue;
                r.put(key, obj);
            }
        }
        return r;
    }

    public static List<String> arrayToList(String[] arry) {
        return Arrays.asList(arry);
    }

    public static List<String> removeDuplicate(List<String> dupliList) {
        if (StrUtil.listIsNotNull(dupliList)) {
            HashSet<String> h = new HashSet<String>(dupliList);
            dupliList.clear();
            dupliList.addAll(h);
        }
        return dupliList;
    }

    public static String getObjectParmByKey(Object user, String key) {
        String parm = null;
        if (null != user && StrUtil.isNotNull(key)) {
            JSONObject userParm = (JSONObject)JSONObject.toJSON((Object)user);
            if (key.contains(".")) {
                String[] keys = key.split("\\.");
                for (int i = 0; i < keys.length; ++i) {
                    if (userParm == null) {
                        return null;
                    }
                    String childKey = keys[i];
                    if (StrUtil.isNull(childKey)) continue;
                    if (i == keys.length - 1) {
                        parm = userParm.getString(childKey);
                        continue;
                    }
                    userParm = userParm.getJSONObject(childKey);
                }
            } else {
                parm = userParm.getString(key);
            }
        }
        return parm;
    }

    public static double str2Double(String str) {
        return StrUtil.str2Double(str, 0.0f);
    }

    public static double str2Double(String str, float defaultValue) {
        double value = defaultValue;
        if (StrUtil.isNull(str)) {
            return defaultValue;
        }
        try {
            value = Double.parseDouble(str);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            return defaultValue;
        }
        return value;
    }

    public static List<String> splitString(String str) {
        if (StrUtil.isNull(str)) {
            return Collections.emptyList();
        }
        return StrUtil.splitString(str, ",");
    }

    public static List<String> splitString(String str, String regex) {
        if (StrUtil.isNull(str) || StrUtil.isNull(regex)) {
            return Collections.emptyList();
        }
        return Arrays.asList(str.split(regex));
    }

    public static String strs(String str) {
        if (str.indexOf(".") > 0) {
            str = str.replaceAll("0+$", "");
            str = str.replaceAll("[.]$", "");
        }
        return str;
    }

    public static String removePercentage(String str, String checkStr) {
        int percentageIndex;
        if (str != null && str.contains(checkStr) && (percentageIndex = str.indexOf(checkStr)) != -1) {
            return str.substring(0, percentageIndex);
        }
        return str;
    }
}

