/*
 * Decompiled with CFR 0.152.
 */
package com.kotelmems.platform.enumerable.loader;

import com.kotelmems.platform.enumerable.EnumItem;
import com.kotelmems.platform.enumerable.loader.EnumLoader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.MappingException;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.util.ClassUtils;

public class JavaEnumLoader
implements EnumLoader {
    private static final String RESOURCE_PATTERN = "/**/*.class";
    private ResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
    private String[] packagesToScan;
    private List<Class<?>> enumClasses = new ArrayList();

    public void setPackagesToScan(String ... packagesToScan) {
        this.packagesToScan = packagesToScan;
    }

    public JavaEnumLoader() {
    }

    public JavaEnumLoader(String ... packagesToScan) {
        this.packagesToScan = packagesToScan;
    }

    @Override
    public Map<String, List<EnumItem>> load() {
        HashMap<String, List<EnumItem>> result = new HashMap<String, List<EnumItem>>();
        if (this.enumClasses.isEmpty()) {
            this.initEnumClass();
        }
        for (Class<?> clazz : this.enumClasses) {
            if (!clazz.isEnum()) continue;
            Method method = null;
            EnumItem[] enums = null;
            try {
                method = clazz.getMethod("values", new Class[0]);
                enums = (EnumItem[])method.invoke(null, null);
            }
            catch (NoSuchMethodException e1) {
                e1.printStackTrace();
            }
            catch (SecurityException e1) {
                e1.printStackTrace();
            }
            catch (IllegalAccessException e1) {
                e1.printStackTrace();
            }
            catch (IllegalArgumentException e1) {
                e1.printStackTrace();
            }
            catch (InvocationTargetException e1) {
                e1.printStackTrace();
            }
            for (EnumItem e : enums) {
                List<EnumItem> ets;
                String key = e.getType();
                if (!result.containsKey(key)) {
                    ets = new ArrayList<EnumItem>();
                    ets.add(e);
                    result.put(key, ets);
                    continue;
                }
                ets = (List)result.get(key);
                ets.add(e);
            }
        }
        return result;
    }

    private boolean isImplementEnumItemInterface(Class<?> clazz) {
        for (Class<?> face : clazz.getInterfaces()) {
            if (!face.equals(EnumItem.class)) continue;
            return true;
        }
        return false;
    }

    public void initEnumClass() {
        try {
            for (String pkg : this.packagesToScan) {
                String pattern = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)pkg) + RESOURCE_PATTERN;
                Resource[] resources = this.resourcePatternResolver.getResources(pattern);
                CachingMetadataReaderFactory readerFactory = new CachingMetadataReaderFactory((ResourceLoader)this.resourcePatternResolver);
                for (Resource resource : resources) {
                    if (!resource.isReadable()) continue;
                    MetadataReader reader = readerFactory.getMetadataReader(resource);
                    String className = reader.getClassMetadata().getClassName();
                    Class<?> clazz = this.resourcePatternResolver.getClassLoader().loadClass(className);
                    clazz.getInterfaces();
                    if (!clazz.isEnum() || !this.isImplementEnumItemInterface(clazz)) continue;
                    this.enumClasses.add(clazz);
                }
            }
        }
        catch (IOException ex) {
            throw new MappingException("Failed to scan classpath for unlisted classes", (Throwable)ex);
        }
        catch (ClassNotFoundException ex) {
            throw new MappingException("Failed to load annotated classes from classpath", (Throwable)ex);
        }
    }
}

