/*
 * Decompiled with CFR 0.152.
 */
package com.kotelmems.platform.enumerable.loader;

import com.kotelmems.platform.enumerable.EnumItem;
import com.kotelmems.platform.enumerable.PlainEnumItem;
import com.kotelmems.platform.enumerable.loader.EnumLoader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.springframework.core.io.Resource;

public class XmlEnumLoader
implements EnumLoader {
    private Resource[] resources;

    public void setResources(Resource ... resources) {
        this.resources = resources;
    }

    public XmlEnumLoader() {
    }

    public XmlEnumLoader(Resource ... resources) {
        this.resources = resources;
    }

    @Override
    public Map<String, List<EnumItem>> load() {
        HashMap<String, List<EnumItem>> result = new HashMap<String, List<EnumItem>>();
        for (Resource resource : this.resources) {
            result.putAll(this.parseXml(resource));
        }
        return result;
    }

    private Map<String, List<EnumItem>> parseXml(Resource resource) {
        HashMap<String, List<EnumItem>> result = new HashMap<String, List<EnumItem>>();
        SAXReader reader = new SAXReader();
        Document doc = null;
        try {
            doc = reader.read(resource.getInputStream());
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Element root = doc.getRootElement();
        List cblist = root.elements("enum");
        for (int i = 0; i < cblist.size(); ++i) {
            Element cbinfo = (Element)cblist.get(i);
            String type = cbinfo.attributeValue("type");
            ArrayList<PlainEnumItem> items = new ArrayList<PlainEnumItem>();
            List entrys = cbinfo.elements("entry");
            for (int j = 0; j < entrys.size(); ++j) {
                Element eninfo = (Element)entrys.get(j);
                String code = eninfo.attributeValue("code");
                String name = eninfo.attributeValue("name");
                String nameI18N = eninfo.attributeValue("nameI18N");
                int index = 0;
                if (null != eninfo.attributeValue("index")) {
                    index = Integer.valueOf(eninfo.attributeValue("index"));
                }
                String nextType = eninfo.attributeValue("nextType");
                PlainEnumItem item = new PlainEnumItem(type, code, name, nameI18N, index, nextType);
                items.add(item);
            }
            result.put(type, items);
        }
        return result;
    }
}

