/*
 * Decompiled with CFR 0.152.
 */
package com.kotelmems.platform.xsqlbuilder;

import com.kotelmems.platform.xsqlbuilder.SafeSqlProcesser;
import com.kotelmems.platform.xsqlbuilder.safesql.DirectReturnSafeSqlProcesser;
import com.kotelmems.platform.xsqlbuilder.safesql.EscapeBackslashAndSingleQuotesSafeSqlProcesser;
import com.kotelmems.platform.xsqlbuilder.safesql.EscapeSingleQuotesSafeSqlProcesser;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.dialect.Dialect;

public class SafeSqlProcesserFactory {
    private static Map cacheDialectMapping = new HashMap();

    private SafeSqlProcesserFactory() {
    }

    public static SafeSqlProcesser getMysql() {
        return new EscapeBackslashAndSingleQuotesSafeSqlProcesser();
    }

    public static SafeSqlProcesser getPostgreSql() {
        return new EscapeBackslashAndSingleQuotesSafeSqlProcesser();
    }

    public static SafeSqlProcesser getMsSqlServer() {
        return new EscapeSingleQuotesSafeSqlProcesser();
    }

    public static SafeSqlProcesser getOracle() {
        return new EscapeSingleQuotesSafeSqlProcesser();
    }

    public static SafeSqlProcesser getDB2() {
        return new EscapeSingleQuotesSafeSqlProcesser();
    }

    public static SafeSqlProcesser getSybase() {
        return new EscapeSingleQuotesSafeSqlProcesser();
    }

    public static SafeSqlProcesser getFromCacheByHibernateDialect(Dialect dialect) {
        SafeSqlProcesser safeSqlProcesser = (SafeSqlProcesser)cacheDialectMapping.get(dialect);
        if (safeSqlProcesser == null) {
            safeSqlProcesser = SafeSqlProcesserFactory.getByHibernateDialect(dialect);
            cacheDialectMapping.put(dialect, safeSqlProcesser);
        }
        return safeSqlProcesser;
    }

    public static SafeSqlProcesser getByHibernateDialect(Dialect dialect) {
        SafeSqlProcesser result = null;
        String dialectClass = dialect.getClass().getSimpleName();
        result = dialectClass.indexOf("MySQL") >= 0 ? SafeSqlProcesserFactory.getMysql() : (dialectClass.indexOf("Oracle") >= 0 ? SafeSqlProcesserFactory.getOracle() : (dialectClass.indexOf("DB2") >= 0 ? SafeSqlProcesserFactory.getDB2() : (dialectClass.indexOf("Postgre") >= 0 ? SafeSqlProcesserFactory.getPostgreSql() : (dialectClass.indexOf("Sybase") >= 0 ? SafeSqlProcesserFactory.getSybase() : (dialectClass.indexOf("SQLServer") >= 0 ? SafeSqlProcesserFactory.getMsSqlServer() : new DirectReturnSafeSqlProcesser())))));
        return result;
    }
}

