/*
 * Decompiled with CFR 0.152.
 */
package com.jumipm.common.email;

import com.alibaba.druid.util.StringUtils;
import com.jumipm.common.email.Mail;
import com.jumipm.common.enumerable.MailType;
import com.jumipm.module.basicConfig.model.EmailBasicConfig;
import com.jumipm.utils.MailConfigInfo;
import com.jumipm.utils.MailUtil;
import com.jumipm.utils.StrUtil;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.mail.Authenticator;
import org.apache.commons.mail.DefaultAuthenticator;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;

public class EMailCoreUtil {
    private static Configuration configuration = new Configuration();

    public static Boolean send(Mail mail) {
        boolean mail_enable = MailConfigInfo.mail_enable;
        if (!mail_enable) {
            return false;
        }
        if (MailType.EXCHANGE.getCode().equals(MailConfigInfo.mail_type)) {
            ArrayList<String> toss = new ArrayList<String>();
            ArrayList<String> toCc = new ArrayList<String>();
            try {
                EMailCoreUtil.setExchangeTo(toss, mail);
                EMailCoreUtil.setExchangeCc(toCc, mail);
                MailUtil.sendExchangeMail(MailConfigInfo.mail_host, MailConfigInfo.mail_username, MailConfigInfo.mail_password, mail.getReceiver(), mail.getSubject(), mail.getMessage(), MailConfigInfo.mail_domain, toss, toCc);
                return true;
            }
            catch (EmailException e) {
                e.printStackTrace();
                return false;
            }
        }
        HtmlEmail email = new HtmlEmail();
        try {
            email.setHostName(MailConfigInfo.mail_host);
            email.setCharset("UTF-8");
            email.setFrom(MailConfigInfo.mail_from, MailConfigInfo.mail_username);
            if (465 == MailConfigInfo.mail_port) {
                email.setAuthenticator((Authenticator)new DefaultAuthenticator(MailConfigInfo.mail_username, MailConfigInfo.mail_password));
                email.setSSLOnConnect(true);
                email.setSmtpPort(MailConfigInfo.mail_port);
            } else {
                email.setAuthentication(MailConfigInfo.mail_username, MailConfigInfo.mail_password);
            }
            EMailCoreUtil.setTo(email, mail);
            EMailCoreUtil.setCc(email, mail);
            EMailCoreUtil.setBcc(email, mail);
            email.setSubject(mail.getSubject());
            email.setHtmlMsg(mail.getMessage());
            email.send();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static Boolean sendOfFromPasswordfree(Mail mail) {
        boolean mail_enable = MailConfigInfo.mail_enable;
        if (!mail_enable) {
            return false;
        }
        if (MailType.EXCHANGE.getCode().equals(MailConfigInfo.mail_type)) {
            ArrayList<String> toss = new ArrayList<String>();
            ArrayList<String> toCc = new ArrayList<String>();
            try {
                EMailCoreUtil.setExchangeTo(toss, mail);
                EMailCoreUtil.setExchangeCc(toCc, mail);
                MailUtil.sendExchangeMail(MailConfigInfo.mail_host, MailConfigInfo.mail_username, "minth+123#", mail.getReceiver(), mail.getSubject(), mail.getMessage(), MailConfigInfo.mail_domain, toss, toCc);
                return true;
            }
            catch (EmailException e) {
                e.printStackTrace();
                return false;
            }
        }
        HtmlEmail email = new HtmlEmail();
        try {
            email.setHostName(MailConfigInfo.mail_host);
            email.setCharset("UTF-8");
            email.setFrom(mail.getSender(), mail.getSender());
            if (465 == MailConfigInfo.mail_port) {
                email.setSSLOnConnect(true);
                email.setSmtpPort(MailConfigInfo.mail_port);
            }
            EMailCoreUtil.setTo(email, mail);
            EMailCoreUtil.setCc(email, mail);
            EMailCoreUtil.setBcc(email, mail);
            email.setSubject(mail.getSubject());
            email.setHtmlMsg(mail.getMessage());
            email.send();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void sendByInformationReminderTemplateAndEmailBasicConfig(Map<String, String> to, List<Map<String, String>> ccList, String emailSubjec, String emailContent, Object businessData, EmailBasicConfig ebc, String sysUrl) {
        Mail mail = new Mail();
        mail.setTo(to);
        mail.setCc(ccList);
        StringBuffer sb = new StringBuffer(200);
        mail.setSubject(emailSubjec);
        StringWriter result = new StringWriter();
        configuration.setDefaultEncoding("UTF-8");
        try {
            Template t = new Template(emailSubjec, (Reader)new StringReader(emailContent), configuration);
            t.process(businessData, (Writer)result);
            sb.append(result.toString());
            sb.append("<br><a href='");
            sb.append(sysUrl);
            sb.append("'>");
            sb.append(sysUrl);
            sb.append("</a>");
            mail.setMessage(sb.toString());
            HtmlEmail email = new HtmlEmail();
            try {
                email.setHostName(ebc.getServerAddress());
                email.setCharset("UTF-8");
                email.setFrom(ebc.getSenderAddress(), ebc.getSenderName());
                if ("1".equals(ebc.getIsSSL())) {
                    email.setAuthenticator((Authenticator)new DefaultAuthenticator(ebc.getAccount(), ebc.getPassword()));
                    email.setSSLOnConnect(true);
                    email.setSmtpPort(Integer.parseInt(ebc.getServerPort()));
                } else {
                    email.setAuthentication(ebc.getAccount(), ebc.getPassword());
                }
                EMailCoreUtil.setTo(email, mail);
                EMailCoreUtil.setCc(email, mail);
                EMailCoreUtil.setBcc(email, mail);
                email.setSubject(mail.getSubject());
                email.setHtmlMsg(mail.getMessage());
                email.send();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void sendByReminderParm(Map<String, String> to, Mail mail, String tempSubject, String tempContent, String businessName, Object businessData, String sysUrl) throws IOException, TemplateException {
        mail.setTo(to);
        StringBuffer sb = new StringBuffer(200);
        if (StrUtil.isNotNull(tempSubject)) {
            mail.setSubject(EMailCoreUtil.EmailTemplateAnalysis(tempSubject, businessName, businessData));
            sb.append(EMailCoreUtil.EmailTemplateAnalysis(tempContent, businessName, businessData));
        } else {
            mail.setSubject(businessName);
            sb.append(businessName);
        }
        sb.append("<br><a href='");
        sb.append(sysUrl);
        sb.append("'>");
        sb.append(sysUrl);
        sb.append("</a>");
        mail.setMessage(sb.toString());
        EMailCoreUtil.send(mail);
    }

    private static void setExchangeTo(List<String> toss, Mail mail) throws EmailException {
        if (!StringUtils.isEmpty((CharSequence)mail.getReceiver())) {
            toss.add(mail.getReceiver());
        }
        if (mail.getTo() != null) {
            for (Map.Entry<String, String> entry : mail.getTo().entrySet()) {
                toss.add(entry.getKey());
            }
        }
    }

    private static void setExchangeCc(List<String> toCc, Mail mail) throws EmailException {
        if (mail.getCc() != null && mail.getCc().size() > 0) {
            for (Map<String, String> iterable_element : mail.getCc()) {
                for (Map.Entry<String, String> entry : iterable_element.entrySet()) {
                    toCc.add(entry.getKey());
                }
            }
        }
    }

    private static void setTo(HtmlEmail email, Mail mail) throws EmailException {
        if (!StringUtils.isEmpty((CharSequence)mail.getReceiver())) {
            if (StringUtils.isEmpty((CharSequence)mail.getReceiverName())) {
                email.addTo(mail.getReceiver(), mail.getReceiverName());
            } else {
                email.addTo(mail.getReceiver());
            }
        }
        if (mail.getTo() != null) {
            for (Map.Entry<String, String> entry : mail.getTo().entrySet()) {
                if (StringUtils.isEmpty((CharSequence)entry.getValue())) {
                    email.addTo(entry.getKey(), entry.getValue());
                    continue;
                }
                email.addTo(entry.getKey());
            }
        }
    }

    private static void setCc(HtmlEmail email, Mail mail) throws EmailException {
        if (mail.getCc() != null && mail.getCc().size() > 0) {
            for (Map<String, String> iterable_element : mail.getCc()) {
                for (Map.Entry<String, String> entry : iterable_element.entrySet()) {
                    if (StringUtils.isEmpty((CharSequence)entry.getValue())) {
                        email.addCc(entry.getKey(), entry.getValue());
                        continue;
                    }
                    email.addCc(entry.getKey());
                }
            }
        }
    }

    private static void setBcc(HtmlEmail email, Mail mail) throws EmailException {
        if (mail.getBcc() != null) {
            for (Map.Entry<String, String> entry : mail.getBcc().entrySet()) {
                if (StringUtils.isEmpty((CharSequence)entry.getValue())) {
                    email.addBcc(entry.getKey(), entry.getValue());
                    continue;
                }
                email.addBcc(entry.getKey());
            }
        }
    }

    private static String EmailTemplateAnalysis(String template, String businessName, Object businessData) throws IOException, TemplateException {
        if (businessData == null) {
            return template;
        }
        StringWriter result = new StringWriter();
        configuration.setDefaultEncoding("UTF-8");
        Template t = new Template(businessName, (Reader)new StringReader(template), configuration);
        t.process(businessData, (Writer)result);
        return result.toString();
    }
}

