/*
 * Decompiled with CFR 0.152.
 */
package com.jumipm.common.utils;

import com.jumipm.utils.DateUtils;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.time.LocalDate;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public class LicenseVerifyCore {
    private static Map<String, Integer> periodDays = new HashMap<String, Integer>();

    public static int getValidityPeriod(String validityPeriod) {
        LocalDate today = LocalDate.now();
        if (periodDays.containsKey(today.toString())) {
            return periodDays.get(today.toString());
        }
        periodDays.clear();
        Date validitydate = DateUtils.localDate2Date(LocalDate.parse(validityPeriod));
        Date now = DateUtils.localDate2Date(today);
        Integer days = DateUtils.calculateDaysByDate(now, validitydate);
        periodDays.put(today.toString(), days);
        return days;
    }

    public static String getLocalMac(InetAddress ia) throws SocketException, UnknownHostException {
        byte[] mac = NetworkInterface.getByInetAddress(ia).getHardwareAddress();
        StringBuffer sb = new StringBuffer("");
        for (int i = 0; i < mac.length; ++i) {
            int temp;
            String str;
            if (i != 0) {
                sb.append("-");
            }
            if ((str = Integer.toHexString(temp = mac[i] & 0xFF)).length() == 1) {
                sb.append("0" + str);
                continue;
            }
            sb.append(str);
        }
        return sb.toString().toUpperCase();
    }

    public static InetAddress getLocalHostLANAddress() throws UnknownHostException {
        try {
            InetAddress candidateAddress = null;
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                Enumeration<InetAddress> inetAddrs = iface.getInetAddresses();
                while (inetAddrs.hasMoreElements()) {
                    InetAddress inetAddr = inetAddrs.nextElement();
                    if (inetAddr.isLoopbackAddress()) continue;
                    if (inetAddr.isSiteLocalAddress()) {
                        return inetAddr;
                    }
                    if (candidateAddress != null) continue;
                    candidateAddress = inetAddr;
                }
            }
            if (candidateAddress != null) {
                return candidateAddress;
            }
            InetAddress jdkSuppliedAddress = InetAddress.getLocalHost();
            if (jdkSuppliedAddress == null) {
                throw new UnknownHostException("The JDK InetAddress.getLocalHost() method unexpectedly returned null.");
            }
            return jdkSuppliedAddress;
        }
        catch (Exception e) {
            UnknownHostException unknownHostException = new UnknownHostException("Failed to determine LAN address: " + e);
            unknownHostException.initCause(e);
            throw unknownHostException;
        }
    }
}

