/*
 * Decompiled with CFR 0.152.
 */
package com.jumipm.license.service;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.jumipm.common.utils.LicenseVerifyCore;
import com.jumipm.common.utils.VerifyParam;
import com.jumipm.license.service.LicenseInfo;
import com.jumipm.utils.CryptHelper;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Repository;

@Order(value=1)
@Repository(value="jmvlc")
public class VerifyLicense
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(VerifyLicense.class);
    private static ApplicationContext applicationContext;
    private static LicenseInfo linfo;
    @Value(value="${config.server.domain:}")
    private String serverDomain;
    @Value(value="${config.sec.key256:}")
    private String key256;
    private AtomicLong count = new AtomicLong(0L);

    @PostConstruct
    private static void init() {
        LicenseInfo licInfo = new LicenseInfo();
        VerifyParam.data = licInfo.getData();
        VerifyParam.count = licInfo.getCount();
        VerifyParam.warningmsg = licInfo.getWarningmsg();
        boolean verify = licInfo.verify();
        if (!verify) {
            ((AbstractApplicationContext)applicationContext).close();
        }
        linfo = licInfo;
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        applicationContext = context;
    }

    public boolean licInfoVerify() {
        boolean result = false;
        try {
            long l = this.count.incrementAndGet();
            long l1 = l % 450L;
            if (l1 != 0L) {
                return true;
            }
            if (l >= Integer.MAX_VALUE) {
                this.count.set(0L);
            }
            Long now = new Date().getTime() / 1000L;
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json; charset=UTF-8");
            JSONObject secureBody = new JSONObject();
            secureBody.put("licsecure", (Object)linfo.getSecure());
            secureBody.put("timestamp", (Object)(now + ""));
            String secure = CryptHelper.sm4Encrypt(secureBody.toJSONString(), this.key256);
            JSONObject body = new JSONObject();
            body.put("username", (Object)linfo.getLicClient());
            body.put("secure", (Object)secure);
            HttpResponse execute = ((HttpRequest)HttpUtil.createPost((String)(this.serverDomain + "/auth/v1/auth")).timeout(2000).addHeaders(headers)).body(body.toJSONString()).execute();
            if (execute.isOk() && execute.getStatus() == 200) {
                JSONObject jsonObject = JSONObject.parseObject((String)execute.body());
                String token = jsonObject.getString("token");
                Long timestamp = jsonObject.getLong("timestamp");
                String username = CryptHelper.sm4Decrypt(token, this.key256);
                long abs = Math.abs(now - timestamp);
                result = linfo.getLicClient().equalsIgnoreCase(username) && abs <= 600L;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public boolean whitelistVerify(String client) {
        try {
            int days = LicenseVerifyCore.getValidityPeriod(linfo.getData());
            return linfo.getClientList().contains(client) && days >= 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

