/*
 * Decompiled with CFR 0.152.
 */
package com.kotelmems.platform.exception;

import com.kotelmems.platform.message.MessageSourceHolder;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Locale;

public class BaseException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private String key;
    private Object[] values;
    private String message;

    public BaseException(String key) {
        this.key = key;
        this.message = this.initMsg();
    }

    public BaseException(String key, String message) {
        this.key = key;
        this.message = message;
    }

    public BaseException(String key, Throwable throwable) {
        super(throwable);
        this.key = key;
        this.message = this.initMsg();
    }

    public BaseException(String key, String message, Throwable throwable) {
        super(throwable);
        this.key = key;
        this.message = message;
    }

    public BaseException(String key, Object[] values) {
        this.key = key;
        this.values = values;
        this.message = this.initMsg();
    }

    public BaseException(String key, Object[] values, Throwable throwable) {
        super(throwable);
        this.key = key;
        this.values = values;
        this.message = this.initMsg();
    }

    public String getKey() {
        return this.key;
    }

    public Object[] getValues() {
        return this.values;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    private String initMsg() {
        return MessageSourceHolder.getMessage(this.key, this.values, Locale.getDefault());
    }

    public String getStackMessage() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.printStackTrace(ps);
        return baos.toString();
    }
}

