/*
 * Decompiled with CFR 0.152.
 */
package com.kotelmems.platform.page;

import com.alibaba.fastjson.JSONObject;
import com.jumipm.common.page.PageRequestMethodArgumentResolver;
import com.jumipm.common.page.reslover.impl.AgGridReslover;
import com.jumipm.utils.SpringUtils;
import com.kotelmems.platform.page.AgParm;
import com.kotelmems.platform.page.PageRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageUtils {
    private static final Logger log = LoggerFactory.getLogger(PageUtils.class);

    private PageUtils() {
    }

    public static int getFirstResult(int pageNumber, int pageSize) {
        if (pageSize <= 0) {
            throw new IllegalArgumentException("[pageSize] must great than zero");
        }
        return (pageNumber - 1) * pageSize;
    }

    public static List<Integer> generateLinkPageNumbers(int currentPageNumber, int lastPageNumber, int count) {
        int endPageNumber;
        int avg = count / 2;
        int startPageNumber = currentPageNumber - avg;
        if (startPageNumber <= 0) {
            startPageNumber = 1;
        }
        if ((endPageNumber = startPageNumber + count - 1) > lastPageNumber) {
            endPageNumber = lastPageNumber;
        }
        if (endPageNumber - startPageNumber < count && (startPageNumber = endPageNumber - count) <= 0) {
            startPageNumber = 1;
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = startPageNumber; i <= endPageNumber; ++i) {
            result.add(new Integer(i));
        }
        return result;
    }

    public static int computeLastPageNumber(int totalElements, int pageSize) {
        int result;
        int n = result = totalElements % pageSize == 0 ? totalElements / pageSize : totalElements / pageSize + 1;
        if (result <= 1) {
            result = 1;
        }
        return result;
    }

    public static int computePageNumber(int pageNumber, int pageSize, int totalElements) {
        if (pageNumber <= 1) {
            return 1;
        }
        if (Integer.MAX_VALUE == pageNumber || pageNumber > PageUtils.computeLastPageNumber(totalElements, pageSize)) {
            return PageUtils.computeLastPageNumber(totalElements, pageSize);
        }
        return pageNumber;
    }

    public static PageRequest changeEntityParm(PageRequest pageRequest, Map<String, String> entrySql, boolean isOnlyCheck) {
        try {
            if (pageRequest == null) {
                return pageRequest;
            }
            PageRequestMethodArgumentResolver bean = SpringUtils.getBean(PageRequestMethodArgumentResolver.class);
            AgGridReslover reslover = (AgGridReslover)bean.getReslover("agData");
            JSONObject agGridParam = pageRequest.getAgGridParam();
            if (agGridParam == null) {
                return pageRequest;
            }
            String queryType = agGridParam.getString("queryType");
            AgParm agParm = reslover.initFilerColumnInfo(agGridParam.getJSONObject("filterModel"), queryType, entrySql);
            pageRequest.setAgParm(agParm);
            String orderInfo = reslover.initOrderColumnInfo(agGridParam.getJSONArray("sortModel"), queryType, entrySql, isOnlyCheck);
            pageRequest.setSortColumns(orderInfo);
        }
        catch (Exception e) {
            log.error("\u5206\u9875\u53c2\u6570\u89e3\u6790\u51fa\u9519\uff1a{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return pageRequest;
    }

    public static PageRequest changeEntityParm(PageRequest pageRequest, Map<String, String> entrySql) {
        return PageUtils.changeEntityParm(pageRequest, entrySql, false);
    }
}

