/*
 * Decompiled with CFR 0.152.
 */
package com.kotelmems.platform.utils;

import com.kotelmems.platform.jdbc.dialect.Dialect;
import com.kotelmems.platform.jdbc.sql.SqlPlan;
import com.kotelmems.platform.jdbc.sql.SqlPlanFactory;
import com.kotelmems.platform.page.Page;
import com.kotelmems.platform.page.PageRequest;
import com.kotelmems.platform.util.PropertiesUtil;
import com.kotelmems.platform.xsqlbuilder.XsqlBuilder;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.CallableStatementCreator;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SqlParameter;

public class JdbcTemplateUtil {
    public Log log = LogFactory.getLog(this.getClass());
    static Dialect dialect;
    private JdbcTemplate jdbcTemplate;

    static {
        String dialectClass = PropertiesUtil.getInstance().getPropertiesValue("jdbc.dialect");
        try {
            dialect = (Dialect)Class.forName(dialectClass).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("cannot create dialect instance by dialectClass:" + dialectClass, e);
        }
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public List queryForList(String sql) {
        return this.getJdbcTemplate().queryForList(sql);
    }

    public List queryForList(String sql, Object parameter) {
        Map args = this.convertObj(parameter);
        SqlPlan sqlplan = this.convertSql(sql, args);
        return this.getJdbcTemplate().queryForList(sqlplan.getPlanSql(), sqlplan.getParameterList(args));
    }

    public Page<Map> queryForPage(String sql, PageRequest pageRequest, Object parameter) {
        Map args = this.convertObj(parameter);
        XsqlBuilder.XsqlFilterResult xsqlRes = new XsqlBuilder().generateHql(sql, parameter);
        sql = xsqlRes.getXsql();
        String countsql = JdbcTemplateUtil.getCountSql(sql);
        int count = this.queryForInt(countsql, args);
        Page page = new Page(pageRequest, count);
        if (StringUtils.isNotBlank((String)pageRequest.getSortColumns())) {
            sql = String.valueOf(sql) + " order by " + pageRequest.getSortColumns();
        }
        int offset = page.getFirstResult();
        int limit = page.getPageSize();
        sql = dialect.supportsLimitOffset() ? dialect.getLimitString(sql, offset, limit) : dialect.getLimitString(sql, 0, limit);
        List result = this.queryForList(sql, args);
        page.setResult(result);
        return page;
    }

    public Map queryForMap(String sql) {
        return this.getJdbcTemplate().queryForMap(sql);
    }

    public Map queryForMap(String sql, Object parameter) {
        Map args = this.convertObj(parameter);
        SqlPlan sqlplan = this.convertSql(sql, args);
        return this.getJdbcTemplate().queryForMap(sqlplan.getPlanSql(), sqlplan.getParameterList(args));
    }

    public int queryForInt(String sql) {
        return this.getJdbcTemplate().queryForInt(sql);
    }

    public int queryForInt(String sql, Object parameter) {
        Map args = this.convertObj(parameter);
        SqlPlan sqlplan = this.convertSql(sql, args);
        return this.getJdbcTemplate().queryForInt(sqlplan.getPlanSql(), sqlplan.getParameterList(args));
    }

    public Long queryForLong(String sql) {
        return this.getJdbcTemplate().queryForLong(sql);
    }

    public Long queryForLong(String sql, Object parameter) {
        Map args = this.convertObj(parameter);
        SqlPlan sqlplan = this.convertSql(sql, args);
        return this.getJdbcTemplate().queryForLong(sqlplan.getPlanSql(), sqlplan.getParameterList(args));
    }

    public Object queryForObject(String sql, Class clazz) {
        return this.getJdbcTemplate().queryForObject(sql, clazz);
    }

    public Object queryForObject(String sql, Object parameter, Class clazz) {
        Map args = this.convertObj(parameter);
        SqlPlan sqlplan = this.convertSql(sql, args);
        return this.getJdbcTemplate().queryForObject(sqlplan.getPlanSql(), sqlplan.getParameterList(args), clazz);
    }

    public List findAllByRowMapperResultReader(String sql, RowMapper rowMapper) {
        return this.getJdbcTemplate().query(sql, rowMapper);
    }

    public List findAllByRowMapperResultReader(String sql, Object parameter, RowMapper rowMapper) {
        Map args = this.convertObj(parameter);
        SqlPlan sqlplan = this.convertSql(sql, args);
        return this.getJdbcTemplate().query(sqlplan.getPlanSql(), sqlplan.getParameterList(args), rowMapper);
    }

    public int update(String sql) {
        return this.getJdbcTemplate().update(sql);
    }

    public int update(String sql, Object parameter) {
        Map args = this.convertObj(parameter);
        SqlPlan sqlplan = this.convertSql(sql, args);
        return this.getJdbcTemplate().update(sqlplan.getPlanSql(), sqlplan.getParameterList(args));
    }

    public Map call(CallableStatementCreator creator, List<SqlParameter> params) {
        return this.getJdbcTemplate().call(creator, params);
    }

    private static String getCountSql(String sql) {
        return "select count(1) from (" + sql + ") t_";
    }

    private SqlPlan convertSql(String sql, Map args) {
        XsqlBuilder.XsqlFilterResult xsqlRes = new XsqlBuilder().generateHql(sql, args);
        String realsql = xsqlRes.getXsql();
        return SqlPlanFactory.getInstance().getPlanCache(realsql);
    }

    private Map convertObj(Object parameter) {
        Map args = null;
        if (parameter instanceof Map) {
            args = (Map)parameter;
        } else {
            try {
                args = PropertyUtils.describe((Object)parameter);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return args;
    }
}

