/*
 * Decompiled with CFR 0.152.
 */
package com.kotelmems.platform.dao.hibernate;

import com.kotelmems.platform.dao.EntityDao;
import com.kotelmems.platform.page.Page;
import com.kotelmems.platform.page.PageRequest;
import com.kotelmems.platform.page.SortInfo;
import com.kotelmems.platform.util.PageQueryUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.processors.DefaultValueProcessor;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.orm.ObjectRetrievalFailureException;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public abstract class BaseHibernateSqlServerDao<E, PK extends Serializable>
extends HibernateDaoSupport
implements EntityDao<E, PK> {
    protected Log log = LogFactory.getLog(this.getClass());

    public long queryForLong(String queryString) {
        return this.queryForLong(queryString, new Object[0]);
    }

    public long queryForLong(String queryString, Object value) {
        return this.queryForLong(queryString, new Object[]{value});
    }

    public long queryForLong(String queryString, Object[] values) {
        return DataAccessUtils.longResult((Collection)this.getHibernateTemplate().find(queryString, values));
    }

    public abstract Class<E> getEntityClass();

    protected void prepareObjectForInsert(E o) {
    }

    protected void prepareObjectForUpdate(E o) {
    }

    @Override
    public E getById(PK id) {
        return (E)this.getHibernateTemplate().get(this.getEntityClass(), id);
    }

    @Override
    public E insert(E entity) {
        this.prepareObjectForInsert(entity);
        Serializable id = this.getHibernateTemplate().save(entity);
        return this.getById(id);
    }

    public void delete(Object entity) {
        this.getHibernateTemplate().delete(entity);
    }

    public void deleteAllByParameter(E parameter) {
        List list;
        if (parameter != null && (list = this.findAllByParam(parameter)).size() > 0) {
            this.getHibernateTemplate().deleteAll((Collection)list);
        }
    }

    public void deleteById(PK id) {
        E entity = this.getById(id);
        if (entity == null) {
            throw new ObjectRetrievalFailureException(this.getEntityClass(), id);
        }
        this.getHibernateTemplate().delete(entity);
    }

    @Override
    public void update(E entity) {
        this.prepareObjectForUpdate(entity);
        this.getHibernateTemplate().update(entity);
    }

    @Override
    public Page<E> findPage(PageRequest pageRequest, Object parameters) {
        this.log.info((Object)"---------------dao-------------\n");
        String sortColumns = BaseHibernateSqlServerDao.isEmpty(pageRequest.getSortColumns()) ? this.getDefaultSortColumn() : pageRequest.getSortColumns();
        List sortList = new ArrayList();
        if (!BaseHibernateSqlServerDao.isEmpty(sortColumns)) {
            sortList = SortInfo.parseSortColumns((String)sortColumns);
        }
        DetachedCriteria totalCrit = DetachedCriteria.forClass(this.getEntityClass());
        totalCrit.setProjection(Projections.rowCount());
        totalCrit.add((Criterion)Example.create((Object)parameters).ignoreCase());
        List totalList = this.getHibernateTemplate().findByCriteria(totalCrit);
        int total = Integer.parseInt(totalList.get(0).toString());
        List list = new ArrayList();
        if (total > 0) {
            final DetachedCriteria listCrit = DetachedCriteria.forClass(this.getEntityClass());
            listCrit.add((Criterion)Example.create((Object)parameters));
            for (SortInfo sortInfo : sortList) {
                if (sortInfo.getSortOrder().equals("desc")) {
                    listCrit.addOrder(Order.desc((String)sortInfo.getColumnName()));
                    continue;
                }
                listCrit.addOrder(Order.asc((String)sortInfo.getColumnName()));
            }
            final PageRequest pageRequestTmp = pageRequest;
            Object parametersTmp = parameters;
            list = (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Object>(){

                public Object doInHibernate(Session session) throws HibernateException, SQLException {
                    Criteria criteria = listCrit.getExecutableCriteria(session);
                    criteria.setFirstResult(pageRequestTmp.getFirstResult());
                    criteria.setMaxResults(pageRequestTmp.getPageSize());
                    return criteria.list();
                }
            });
        }
        Page page = new Page(pageRequest, total);
        page.setResult(list);
        return page;
    }

    public void saveOrUpdate(E entity) {
        this.getHibernateTemplate().saveOrUpdate(entity);
    }

    public void saveAll(Collection<E> entities) {
        Iterator<E> it = entities.iterator();
        while (it.hasNext()) {
            this.insert(it.next());
        }
    }

    public void deleteAll(Collection<E> entities) {
        this.getHibernateTemplate().deleteAll(entities);
    }

    public void refresh(Object entity) {
        this.getHibernateTemplate().refresh(entity);
    }

    public void flush() {
        this.getHibernateTemplate().flush();
    }

    public void evict(Object entity) {
        this.getHibernateTemplate().evict(entity);
    }

    public E findFirst(E entity) {
        List list = this.findAllByParam(entity);
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public List<E> findAll() {
        String sortColumns;
        StringBuffer queryStringBuff = new StringBuffer(" FROM ").append(this.getEntityClass().getSimpleName());
        String string = sortColumns = BaseHibernateSqlServerDao.isEmpty(this.getDefaultSortColumn()) ? "" : this.getDefaultSortColumn();
        if (!BaseHibernateSqlServerDao.isEmpty(sortColumns)) {
            queryStringBuff.append(" ORDER BY " + sortColumns);
        }
        final String queryString = queryStringBuff.toString();
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query query = session.createQuery(queryString);
                List list = query.list();
                return list;
            }
        });
    }

    public Page findAll(PageRequest pageRequest) {
        String sortColumns;
        StringBuffer queryStringBuff = new StringBuffer(" FROM ").append(this.getEntityClass().getSimpleName());
        final String countQueryString = "SELECT count(*) " + queryStringBuff.toString();
        String string = sortColumns = BaseHibernateSqlServerDao.isEmpty(pageRequest.getSortColumns()) ? this.getDefaultSortColumn() : pageRequest.getSortColumns();
        if (!BaseHibernateSqlServerDao.isEmpty(sortColumns)) {
            queryStringBuff.append(" ORDER BY " + sortColumns);
        }
        final String queryString = queryStringBuff.toString();
        final PageRequest finalPageRequest = pageRequest;
        return (Page)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query query = session.createQuery(queryString);
                Query countQuery = session.createQuery(countQueryString);
                return PageQueryUtils.executeQueryForPage((PageRequest)finalPageRequest, (Query)query, (Query)countQuery);
            }
        });
    }

    public Page findPageAllByParam(PageRequest pageRequest, Object parameters) {
        String sortColumns;
        StringBuffer queryStringBuff = new StringBuffer(" FROM ").append(this.getEntityClass().getSimpleName());
        this.initQueryPrama(parameters, queryStringBuff, pageRequest);
        final String countQueryString = "SELECT count(*) " + queryStringBuff.toString();
        String string = sortColumns = BaseHibernateSqlServerDao.isEmpty(pageRequest.getSortColumns()) ? this.getDefaultSortColumn() : pageRequest.getSortColumns();
        if (!BaseHibernateSqlServerDao.isEmpty(sortColumns)) {
            queryStringBuff.append(" ORDER BY " + sortColumns);
        }
        final String queryString = queryStringBuff.toString();
        System.out.println("---------queryString:          " + queryString);
        final PageRequest finalPageRequest = pageRequest;
        final Object finalparameters = parameters;
        return (Page)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query query = session.createQuery(queryString);
                BaseHibernateSqlServerDao.this.initSearchProperties(query, finalPageRequest, finalparameters);
                Query countQuery = session.createQuery(countQueryString);
                BaseHibernateSqlServerDao.this.initSearchProperties(countQuery, finalPageRequest, finalparameters);
                return PageQueryUtils.executeQueryForPage((PageRequest)finalPageRequest, (Query)query, (Query)countQuery);
            }
        });
    }

    private void initSearchProperties(Query querySearch, PageRequest finalPageRequest, Object parameters) {
        if (parameters != null) {
            JSONObject obj = this.covertJsonFromObject(parameters);
            Set objSet = obj.keySet();
            int count = 0;
            for (String key : objSet) {
                String value = obj.getString(key);
                if (!StringUtils.isNotEmpty((String)value) || !StringUtils.isNotBlank((String)value) || "null".equals(value)) continue;
                querySearch.setParameter(count, (Object)value);
                System.out.println("kcolumnStr" + key + "    count:" + count + "      value:" + value);
                ++count;
            }
            if (finalPageRequest != null && StringUtils.isNotBlank((String)finalPageRequest.getsSearch()) && StringUtils.isNotEmpty((String)finalPageRequest.getsSearch())) {
                for (String columnStr : objSet) {
                    if (columnStr.indexOf("Date") != -1 || columnStr.indexOf("date") != -1 || columnStr.indexOf("Time") != -1 || columnStr.indexOf("Type") != -1) continue;
                    System.out.println("columnStr:   " + columnStr + " count:" + count + "    searCh:" + finalPageRequest.getsSearch());
                    querySearch.setParameter(count, (Object)("%" + finalPageRequest.getsSearch() + "%"));
                    ++count;
                }
            }
        }
    }

    public Page findPageAllByInProperty(PageRequest pageRequest, Map parametersIn) {
        String sortColumns;
        StringBuffer queryStringBuff = new StringBuffer(" FROM ").append(this.getEntityClass().getSimpleName());
        final List ls = this.initQueryPramaIn(parametersIn, queryStringBuff);
        final String countQueryString = "SELECT count(*) " + queryStringBuff.toString();
        String string = sortColumns = BaseHibernateSqlServerDao.isEmpty(pageRequest.getSortColumns()) ? this.getDefaultSortColumn() : pageRequest.getSortColumns();
        if (!BaseHibernateSqlServerDao.isEmpty(sortColumns)) {
            queryStringBuff.append(" ORDER BY " + sortColumns);
        }
        final String queryString = queryStringBuff.toString();
        final PageRequest finalPageRequest = pageRequest;
        return (Page)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query query = session.createQuery(queryString);
                if (ls != null && ls.size() > 0) {
                    query.setParameterList("list", (Collection)ls);
                }
                Query countQuery = session.createQuery(countQueryString);
                if (ls != null && ls.size() > 0) {
                    countQuery.setParameterList("list", (Collection)ls);
                }
                return PageQueryUtils.executeQueryForPage((PageRequest)finalPageRequest, (Query)query, (Query)countQuery);
            }
        });
    }

    public List findPageAllNoPageByInProperty(Map parametersIn) {
        StringBuffer queryStringBuff = new StringBuffer(" FROM ").append(this.getEntityClass().getSimpleName());
        final List ls = this.initQueryPramaIn(parametersIn, queryStringBuff);
        final String queryString = queryStringBuff.toString();
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query query = session.createQuery(queryString);
                if (ls != null && ls.size() > 0) {
                    query.setParameterList("list", (Collection)ls);
                }
                return query.list();
            }
        });
    }

    public List findAllByParam(Object parameters) {
        String sortColumns;
        StringBuffer queryStringBuff = new StringBuffer(" FROM ").append(this.getEntityClass().getSimpleName());
        this.initQueryPrama(parameters, queryStringBuff, null);
        String string = sortColumns = BaseHibernateSqlServerDao.isEmpty(this.getDefaultSortColumn()) ? "" : this.getDefaultSortColumn();
        if (!BaseHibernateSqlServerDao.isEmpty(sortColumns)) {
            queryStringBuff.append(" ORDER BY " + sortColumns);
        }
        final String queryString = queryStringBuff.toString();
        final Object finalparameters = parameters;
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query query = session.createQuery(queryString);
                BaseHibernateSqlServerDao.this.initSearchProperties(query, null, finalparameters);
                List list = query.list();
                return list;
            }
        });
    }

    public List findAllByParamLike(Object parameters) {
        String sortColumns;
        StringBuffer queryStringBuff = new StringBuffer(" FROM ").append(this.getEntityClass().getSimpleName());
        final String param = this.initQueryPramaLike(parameters, queryStringBuff);
        String string = sortColumns = BaseHibernateSqlServerDao.isEmpty(this.getDefaultSortColumn()) ? "" : this.getDefaultSortColumn();
        if (!BaseHibernateSqlServerDao.isEmpty(sortColumns)) {
            queryStringBuff.append(" ORDER BY " + sortColumns);
        }
        final String queryString = queryStringBuff.toString();
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query query = session.createQuery(queryString);
                query.setString("param", String.valueOf(param) + "%");
                return query.list();
            }
        });
    }

    public Page<?> pageQuery(String hql, PageRequest pageRequest, Object parameters) {
        String countHql = PageQueryUtils.createCountSql((String)hql);
        return this.pageQuery(hql, countHql, pageRequest, parameters);
    }

    public Page<?> pageQuery(String hql, String countHql, PageRequest pageRequest, Object parameters) {
        return PageQueryUtils.pageQuery((HibernateTemplate)this.getHibernateTemplate(), (String)hql, (String)countHql, (PageRequest)pageRequest, (Object)parameters);
    }

    private static boolean isEmpty(Object id) {
        if (id == null) {
            return true;
        }
        if (id instanceof String) {
            return StringUtils.isEmpty((String)((String)id));
        }
        return false;
    }

    private void initQueryPrama(Object parameters, StringBuffer queryStringBuff, PageRequest pageRequest) {
        if (parameters == null && pageRequest == null) {
            return;
        }
        if (parameters == null && StringUtils.isEmpty((String)pageRequest.getsSearch()) && StringUtils.isBlank((String)pageRequest.getsSearch())) {
            return;
        }
        JSONObject obj = null;
        ArrayList<String> ls = new ArrayList<String>();
        if (parameters != null) {
            obj = this.covertJsonFromObject(parameters);
            Iterator it = obj.keys();
            while (it.hasNext()) {
                String key = (String)it.next();
                String value = obj.getString(key);
                if (!StringUtils.isNotEmpty((String)value) || !StringUtils.isNotBlank((String)value) || "null".equals(value)) continue;
                ls.add(key);
            }
        }
        if (ls.size() > 0) {
            queryStringBuff.append(" c where ");
            int j = 0;
            while (j < ls.size()) {
                queryStringBuff.append(" c." + ls.get(j) + "= ? ");
                if (j < ls.size() - 1) {
                    queryStringBuff.append(" and ");
                }
                ++j;
            }
        }
        if (pageRequest != null && StringUtils.isNotEmpty((String)pageRequest.getsSearch()) && StringUtils.isNotBlank((String)pageRequest.getsSearch())) {
            if (ls.size() == 0) {
                queryStringBuff.append(" c where ");
            } else {
                queryStringBuff.append(" and ");
            }
            queryStringBuff.append(this.constructionSearchQuery(obj));
        }
    }

    private String constructionSearchQuery(JSONObject obj) {
        StringBuffer sbufferSearch = new StringBuffer();
        Set objset = obj.keySet();
        ArrayList<String> lsobj = new ArrayList<String>();
        if (objset != null && objset.size() > 0) {
            for (Object object : objset) {
                String key = (String)object;
                if (key.indexOf("Date") != -1 || key.indexOf("date") != -1 || key.indexOf("Time") != -1 || key.indexOf("Type") != -1) continue;
                lsobj.add(key);
            }
            sbufferSearch.append("(");
            int i = 0;
            while (i < lsobj.size()) {
                if (i == lsobj.size() - 1) {
                    sbufferSearch.append("c." + (String)lsobj.get(i) + " like ? )");
                } else {
                    sbufferSearch.append("c." + (String)lsobj.get(i) + " like ? or ");
                }
                ++i;
            }
        }
        return sbufferSearch.toString();
    }

    private List initQueryPramaIn(Map parametersIn, StringBuffer queryStringBuff) {
        List valueLs = new ArrayList();
        if (parametersIn != null) {
            Iterator iterator = parametersIn.entrySet().iterator();
            String keyStr = "";
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                keyStr = (String)entry.getKey();
                valueLs = (List)entry.getValue();
            }
            if (valueLs != null && valueLs.size() > 0) {
                queryStringBuff.append(" c where ");
                queryStringBuff.append(" c." + keyStr + " in (:list) ");
            }
        }
        return valueLs;
    }

    private List initQueryPramaNotIn(Map parametersIn, StringBuffer queryStringBuff) {
        List valueLs = new ArrayList();
        if (parametersIn != null) {
            Iterator iterator = parametersIn.entrySet().iterator();
            String keyStr = "";
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                keyStr = (String)entry.getKey();
                valueLs = (List)entry.getValue();
            }
            if (valueLs != null && valueLs.size() > 0) {
                queryStringBuff.append(" c where ");
                queryStringBuff.append(" c." + keyStr + " not in (:list) ");
            }
        }
        return valueLs;
    }

    private String initQueryPramaLike(Object parameters, StringBuffer queryStringBuff) {
        String likeValue = "";
        if (parameters != null) {
            JSONObject obj = this.covertJsonFromObject(parameters);
            Iterator it = obj.keys();
            ArrayList<String> ls = new ArrayList<String>();
            while (it.hasNext()) {
                String key = (String)it.next();
                String value = obj.getString(key);
                if (!StringUtils.isNotEmpty((String)value) || !StringUtils.isNotBlank((String)value) || "null".equals(value)) continue;
                ls.add(key);
                likeValue = value;
                break;
            }
            if (ls.size() > 0) {
                queryStringBuff.append(" c where ");
                int j = 0;
                while (j < ls.size()) {
                    queryStringBuff.append(" c." + ls.get(j) + " like:param");
                    if (j < ls.size() - 1) {
                        queryStringBuff.append(" and ");
                    }
                    ++j;
                }
            }
        }
        return likeValue;
    }

    private JSONObject covertJsonFromObject(Object parameters) {
        JsonConfig jsonConfig = new JsonConfig();
        jsonConfig.registerDefaultValueProcessor(Long.class, new DefaultValueProcessor(){

            public Object getDefaultValue(Class type) {
                return null;
            }
        });
        jsonConfig.registerDefaultValueProcessor(Integer.class, new DefaultValueProcessor(){

            public Object getDefaultValue(Class type) {
                return null;
            }
        });
        jsonConfig.registerDefaultValueProcessor(Double.class, new DefaultValueProcessor(){

            public Object getDefaultValue(Class type) {
                return null;
            }
        });
        jsonConfig.registerDefaultValueProcessor(BigDecimal.class, new DefaultValueProcessor(){

            public Object getDefaultValue(Class type) {
                return null;
            }
        });
        jsonConfig.registerDefaultValueProcessor(BigInteger.class, new DefaultValueProcessor(){

            public Object getDefaultValue(Class type) {
                return null;
            }
        });
        jsonConfig.registerDefaultValueProcessor(Float.class, new DefaultValueProcessor(){

            public Object getDefaultValue(Class type) {
                return null;
            }
        });
        jsonConfig.registerDefaultValueProcessor(Set.class, new DefaultValueProcessor(){

            public Object getDefaultValue(Class type) {
                return null;
            }
        });
        JSONObject obj = JSONObject.fromObject((Object)parameters, (JsonConfig)jsonConfig);
        return obj;
    }
}

