/*
 * Decompiled with CFR 0.152.
 */
package com.kotelmems.platform.dao.ibatis3;

import com.kotelmems.platform.dao.EntityDao;
import com.kotelmems.platform.page.Page;
import com.kotelmems.platform.page.PageRequest;
import com.kotelmems.platform.util.UUIDHexGenerator;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ibatis.session.RowBounds;
import org.mybatis.spring.SqlSessionTemplate;

public abstract class BaseMybatisDao<E, PK extends Serializable>
implements EntityDao<E, PK> {
    protected final Log log = LogFactory.getLog(this.getClass());
    private SqlSessionTemplate sqlSessionTemplate;

    public void setSqlSessionTemplate(SqlSessionTemplate sqlSessionTemplate) {
        this.sqlSessionTemplate = sqlSessionTemplate;
    }

    public SqlSessionTemplate getSqlSessionTemplate() {
        return this.sqlSessionTemplate;
    }

    public abstract String getIbatisMapperNamespace();

    @Override
    public E getById(PK primaryKey) {
        Object object = this.getSqlSessionTemplate().selectOne(this.getFindByPrimaryKeyStatement(), primaryKey);
        return (E)object;
    }

    public void deleteById(PK primaryKey) {
        this.getSqlSessionTemplate().delete(this.getDeleteStatement(), primaryKey);
    }

    @Override
    public E insert(E entity) {
        this.prepareObjectForSave(entity);
        Integer object = this.getSqlSessionTemplate().insert(this.getInsertStatement(), entity);
        return (E)object;
    }

    @Override
    public void update(E entity) {
        this.prepareObjectForUpdate(entity);
        this.getSqlSessionTemplate().update(this.getUpdateStatement(), entity);
    }

    public List<?> find(String statementName, Object findvo) {
        statementName = this.getIbatisMapperNamespace().concat(".").concat(statementName);
        return this.getSqlSessionTemplate().selectList(statementName, findvo);
    }

    @Override
    public Page<E> findPage(PageRequest pageRequest, Object parameters) {
        Map params = null;
        try {
            params = BeanUtils.describe((Object)parameters);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        String sortColumns = (String)params.get("sortColumns");
        if (BaseMybatisDao.isEmpty(sortColumns)) {
            sortColumns = BaseMybatisDao.isEmpty(pageRequest.getSortColumns()) ? this.getDefaultSortColumn() : pageRequest.getSortColumns();
            params.put("sortColumns", sortColumns);
        }
        if (pageRequest.getPageSize() <= 0) {
            throw new IllegalArgumentException("PageSize can't be 0");
        }
        return this.pageQuery("findPage", pageRequest, params);
    }

    public Page<?> pageQuery(String statementName, PageRequest pageRequest, Object parameters) {
        return this.pageQuery(this.getPageQueryStatement(statementName), this.getCountStatementForPaging(statementName), pageRequest, parameters);
    }

    private Page<?> pageQuery(String statementName, String countStatementName, PageRequest pageRequest, Object parameters) {
        Number totalCount = (Number)this.getSqlSessionTemplate().selectOne(countStatementName, parameters);
        if (totalCount == null || totalCount.longValue() <= 0L) {
            return new Page(pageRequest, 0);
        }
        Page page = new Page(pageRequest, totalCount.intValue());
        List list = this.sqlSessionTemplate.selectList(statementName, parameters, new RowBounds(pageRequest.getFirstResult(), pageRequest.getPageSize()));
        page.setResult(list);
        return page;
    }

    protected void prepareObjectForSave(E o) {
    }

    protected void prepareObjectForUpdate(E o) {
    }

    public String getFindByPrimaryKeyStatement() {
        return String.valueOf(this.getIbatisMapperNamespace()) + ".getById";
    }

    public String getInsertStatement() {
        return String.valueOf(this.getIbatisMapperNamespace()) + ".insert";
    }

    public String getUpdateStatement() {
        return String.valueOf(this.getIbatisMapperNamespace()) + ".update";
    }

    public String getDeleteStatement() {
        return String.valueOf(this.getIbatisMapperNamespace()) + ".delete";
    }

    public String getPageQueryStatement(String statementName) {
        return this.getIbatisMapperNamespace().concat(".").concat(statementName);
    }

    public String getCountStatementForPaging(String statementName) {
        return this.getIbatisMapperNamespace().concat(".").concat(statementName).concat("_count");
    }

    public static String getUUID() {
        return UUIDHexGenerator.getUUIDHex();
    }

    public static boolean isEmpty(Object id) {
        if (id == null) {
            return true;
        }
        if (id instanceof String) {
            return StringUtils.isEmpty((String)((String)id));
        }
        return false;
    }
}

