/*
 * Decompiled with CFR 0.152.
 */
package com.kotelmems.platform.vo;

import com.jumipm.utils.StrUtil;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class DaoCustomParm {
    @NotNull
    private String key;
    @NotNull
    private String doType = "do_eq";
    private Object parm;
    private Object[] inParm;
    private Date dateParm;
    private BigDecimal decimalParm;
    private Type type;

    public DaoCustomParm() {
    }

    public DaoCustomParm(String key, Object parm) {
        this.key = key;
        this.parm = parm;
    }

    public DaoCustomParm(String key, Object parm, String doType) {
        this.key = key;
        this.parm = parm;
        this.doType = doType;
    }

    public DaoCustomParm(String key, Object[] inParm) {
        this.key = key;
        this.doType = "do_in";
        this.inParm = inParm;
    }

    public DaoCustomParm(String key, List<String> inParm) {
        this.key = key;
        this.doType = "do_in";
        this.inParm = StrUtil.listToArray(inParm);
    }

    public DaoCustomParm(String key, Object[] inParm, String doType) {
        this.key = key;
        this.inParm = inParm;
        this.doType = "do_in".equals(doType) ? "do_in" : "do_notin";
    }

    public DaoCustomParm(String key, List<String> inParm, String doType) {
        this.key = key;
        this.inParm = StrUtil.listToArray(inParm);
        this.doType = "do_in".equals(doType) ? "do_in" : "do_notin";
    }

    public DaoCustomParm(String key, Date dateParm, String doType) {
        this.key = key;
        this.dateParm = dateParm;
        this.doType = doType;
        this.type = StandardBasicTypes.DATE;
    }

    public DaoCustomParm(String key, Date dateParm, String doType, Type type) {
        this.key = key;
        this.dateParm = dateParm;
        this.doType = doType;
        this.type = type;
    }

    public DaoCustomParm(String key, BigDecimal decimalParm, String doType) {
        this.key = key;
        this.decimalParm = decimalParm;
        this.doType = doType;
        this.type = StandardBasicTypes.BIG_DECIMAL;
    }

    public DaoCustomParm(String key, BigDecimal decimalParm, String doType, Type type) {
        this.key = key;
        this.decimalParm = decimalParm;
        this.doType = doType;
        this.type = type;
    }

    @NotNull
    public String getKey() {
        return this.key;
    }

    @NotNull
    public String getDoType() {
        return this.doType;
    }

    public Object getParm() {
        return this.parm;
    }

    public Object[] getInParm() {
        return this.inParm;
    }

    public Date getDateParm() {
        return this.dateParm;
    }

    public BigDecimal getDecimalParm() {
        return this.decimalParm;
    }

    public Type getType() {
        return this.type;
    }

    public void setKey(@NotNull String key) {
        this.key = key;
    }

    public void setDoType(@NotNull String doType) {
        this.doType = doType;
    }

    public void setParm(Object parm) {
        this.parm = parm;
    }

    public void setInParm(Object[] inParm) {
        this.inParm = inParm;
    }

    public void setDateParm(Date dateParm) {
        this.dateParm = dateParm;
    }

    public void setDecimalParm(BigDecimal decimalParm) {
        this.decimalParm = decimalParm;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String toString() {
        return "DaoCustomParm(key=" + this.getKey() + ", doType=" + this.getDoType() + ", parm=" + this.getParm() + ", inParm=" + Arrays.deepToString(this.getInParm()) + ", dateParm=" + this.getDateParm() + ", decimalParm=" + this.getDecimalParm() + ", type=" + this.getType() + ")";
    }
}

