/*
 * Decompiled with CFR 0.152.
 */
package com.kotelmems.platform.jdbc.support;

import com.kotelmems.platform.jdbc.support.OffsetLimitResultSetExtractor;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.util.Assert;

public class OffsetLimitPreparedStatementCallback
implements PreparedStatementCallback {
    private int offset;
    private int limit;
    private RowMapper rowMapper;

    public OffsetLimitPreparedStatementCallback(int offset, int limit, RowMapper rowMapper) {
        Assert.notNull((Object)rowMapper, (String)"'rowMapper' must be not null");
        this.offset = offset;
        this.limit = limit;
        this.rowMapper = rowMapper;
    }

    public Object doInPreparedStatement(PreparedStatement ps) throws SQLException, DataAccessException {
        ps.setMaxRows(this.limit);
        ResultSet rs = null;
        try {
            rs = ps.executeQuery();
            OffsetLimitResultSetExtractor rse = new OffsetLimitResultSetExtractor(this.offset, this.limit, this.rowMapper);
            List list = (List)rse.extractData(rs);
            return list;
        }
        finally {
            JdbcUtils.closeResultSet((ResultSet)rs);
        }
    }
}

