package com.jumipm.workflow;

import java.util.List;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jumipm.workflow.impl.FlowElement;
import com.jumipm.workflow.impl.TaskInfo;


/**
 * 流程引擎
 * 在使用activiti的时候需要1、加入oracle驱动、2修改db.property文件、3在activiti-custom-context.xml的engine配置中增加<property name="databaseSchema" value="XJLFLOW"/><br>
 * 流程图中看到的字体是乱码，修改了流程发布字符集，参考activiti自建工程包org.activiti.editor.ui.EditorProcessDefinitionDetailPanel
 * @author bingjun.song@jumipm.com
 *
 */

public interface FlowEngine {
	/**
	 * 得到所有的发布流程
	 * @return
	 */
	public String getDeployments()  throws Exception;
	/**
	 * 得到一个发布流程的信息
	 * @param deployId
	 * @return
	 */
	public String getDeployment(String deployId)  throws Exception;

	/**
	 * 获取所有已部署的流程定义
	 * 
	 * @return
	 */
	public String getProcessDefinitions()  throws Exception;
	
	
	/**
	 * 获取流程图Url
	 * 
	 * @param processKey 流程定义key
	 * @return
	 */
	public String getProcessGraphUrl(String processKey)  throws Exception;
	
	public String getProcessTrackGraphUrl(String businessKey)  throws Exception;

	/**
	 * 得到流程定义
	 * @param processDefinitionId 流程id
	 * @return
	 */
	public String getProcessDefinitionById(String processDefinitionId) throws Exception ;
	/**
	 * 得到流程定义
	 * @param processDefinitionKey 流程Key
	 * @return
	 */
	public String getProcessDefinitionByKey(String processDefinitionKey) throws Exception;
	
	/**
	 * 得到一个流程图
	 * @param processDefinitionId
	 * @return
	 */
	public byte[] getProcessDefinitionImage(String processDefinitionId) throws Exception;
	
	/**
	 * 得到流程定义ID
	 * @param processKey
	 * @return
	 */
	public String getProcessDefinetionId(String processKey) throws Exception;
	/**
	 * 得到一个流程图 根据流程key(流程名称)
	 * @param processKey
	 * @return
	 */
	public byte[] getProcessDefinitionImageByKey(String processKey) throws Exception;
	
	
	/**
	 * 获取流程实例图Url
	 * @param processInstanceId
	 * @return
	 */
	public String getActivitiProcessTrackByProcessInstanceId(String processInstanceId) throws Exception;
	/**
	 * 启动一个业务流程
	 * 
	 * @param processDefinitionId  流程定义ID
	 * @param businessKey 业务Key
	 * @param variables 启动流程实例变量
	 * @return 流程实例ID
	 */
	public String startProcessById(String processDefinitionId, String businessKey,JSONArray variables) throws Exception;
	/**
	 * 启动一个业务流程
	 * @param processDefinitionKey 流程定义Key
	 * @param businessKey
	 * @param variables 启动流程实例变量
	 * 	@return 流程实例ID
	 */
	public String startProcessByKey(String processDefinitionKey, String businessKey,JSONArray variables) throws Exception;
	
	/**
	 * 指定启动提交
	 * 
	 * @param processDefinitionKey 流程定义key
	 * @param businessKey          业务主键
	 * @param assigneeOrRole       代办角色
	 * @param owner                任务拥有者
	 * @param description
	 * @param variables
	 */
	public void appointStartProcessByKey(String processDefinitionKey, String businessKey,String assigneeOrRole,String owner,String description,JSONArray variables) throws Exception;
	/**
	 * 得到所有待办任务
	 * @param userId 用户id
	 * @return
	 */
	public List<TaskInfo> getMyTask(String userId) throws Exception;
	
	/**
	 * 获取审批历史任务列表
	 * @param bussinessKey
	 * @return
	 */
	public List<TaskInfo> getMyHistoryTask(String bussinessKey) throws Exception;
	
	/**
	 * 得到所有待办任务bussikey
	 * @param userId 用户id
	 * @return
	 */
	public List<String> getTodoBusinessKeyByAssignee(String userId) throws Exception;
	  /**
     * 通过实例ID获取流程实例
     * 参数：processInstanceId 流程实例ID
     *
     * @throws Exception
     */
    
    public JSONObject getJsonObjProcessInstanceById(String processInstanceId) throws Exception;
	/**
	 * 得到待办任务列表
	 * @param userId 用户id
	 * @param processDefinitionKey 流程key
	 * @return
	 */
	public List<TaskInfo> getMyTask(String userId, String processDefinitionKey) throws Exception;
	/**
	 * 可以认领的任务
	 * @param userId
	 * @return
	 */
    public List getCandidaTask(String userId) throws Exception;
	/**
	 * 得到所有组的任务，还没有分配给我，但是我可以认领的
	 * 
	 * @return
	 */
	public List getGroupTask(String userId) throws Exception;
	/**
	 * 认领任务
	 */
	public void claimTask(String taskId, String userId) throws Exception;

	/**
	 * 执行任务
	 * 
	 * @param taskId
	 */
	public void completeTask(String taskId, JSONArray variables) throws Exception;
	
	/**
	 * 更新task
	 * 
	 * @param taskId
	 * @param description 任务描述 此处记录审批意见
	 * @param owner       任
	 * 务拥有者
	 */
	public void updateTask(String taskId,String description,String owner) throws Exception;
	
	
	/**
	 * 执行审批任务 通过业务主键 businessKey
	 * 
	 * @param businessKey
	 * @param assigneeOrRole
	 */
	/**
	 * @param businessKey
	 * @param assigneeOrRole
	 * @return 0-未到最后节点 1-到最后节点
	 */
	public int appointCompleteTask(String businessKey,String assigneeOrRole,String owner,String description,JSONArray variables) throws Exception;
	
	/**
	 * 通过businessKey 获取运行的taskId
	 * 
	 * @param businessKey
	 * @return
	 */
	public TaskInfo getTaskByBusinessKey(String businessKey) throws Exception;
	
	/**
	 * 得到我参与过的任务
	 * @param userId
	 * @return
	 */
	public List getHistoryTask(String userId) throws Exception;
	/**
	 * 增加一个用户到realNameGroup
	 * 
	 */
	public void addUser(String id, String firstName, String lastName, String email,String password) throws Exception;
	public void addUserToGroup(String userId, String groupId) throws Exception;
	
	
	/**
	 * 获取流程包含的流程节点信息
	 * @param processDefinitionId
	 */
	public List<FlowElement> getFlowElementsByDefinitionId(String processDefinitionId) throws Exception;
	

}
