package com.jumipm.workflow;

import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;

import sun.misc.BASE64Encoder;



/**
 * Created by dell on 14-5-22.
 */
public class HttpDisposeUtil {
    /**
     * 通过调用rest API访问activiti服务相关信息
     *
     * @throws Exception
     */
    //static String serviceUrl = "http://192.168.0.123:8080/KTWorkflow/service";

    private String serviceUrl;
    public HttpDisposeUtil(String service)
    {
        this.serviceUrl = service;
    }

    /**
     * Rest方式访问
     *
     * @param type 1,GET 获得一个资源或获得多个资源
     *             2,POST 创建一个新资源。当请求结果太复杂，无法放到GET请求的URL中，也用来查询资源。
     *             3,PUT 更新已有资源的属性。也用来调用现存资源的功能。
     *             4,DELETE 删除现存资源。
     * @return
     * @throws Exception
     */
    public String getResponseForURLConnection(String type, String inUrl) throws Exception {
        String sResult = "";
        try {
            HttpURLConnection urlConn = null;
            String url = serviceUrl + inUrl;
            URL httpUrl = new URL(url);
            urlConn = (HttpURLConnection) httpUrl.openConnection();
            urlConn.setConnectTimeout(20000);
            String rsp = null;

            /**
             * 1,GET 获得一个资源或获得多个资源
             * 2,POST 创建一个新资源。当请求结果太复杂，无法放到GET请求的URL中，也用来查询资源。
             * 3,PUT 更新已有资源的属性。也用来调用现存资源的功能。
             * 4,DELETE 删除现存资源。
             */
            //1,GET 获得一个资源或获得多个资源
            if ("GET".equals(type)) {
                urlConn.setRequestMethod(type);
                urlConn.addRequestProperty("Content-Type", "application/json");
                //设置Authentication头部：添加有效的activiti用户认证信息 【用户<kermit>:密码<kermit>】
                String userNamePassWord = "kermit:kermit";
                String author = (new BASE64Encoder()).encode(userNamePassWord.getBytes());
                urlConn.addRequestProperty("Authorization", "Basic " + author);
                //200操作成功，响应返回（GET和PUT请求）。
                if (urlConn.getResponseCode() == 200) {
                    InputStreamReader isr = new InputStreamReader(
                            urlConn.getInputStream(), "UTF-8");
                    int i;
                    while ((i = isr.read()) != -1) {
                        sResult = sResult + (char) i;
                    }
                    System.out.println("\nsResult:"+sResult);
                    isr.close();
                }
                return sResult;
            }
            //2,POST 创建一个新资源。当请求结果太复杂，无法放到GET请求的URL中，也用来查询资源。
            if ("POST".equals(type)) {
                urlConn.setRequestMethod("POST");
                urlConn.setDoInput(true);
                urlConn.setDoOutput(true);
                urlConn.setUseCaches(false);
                urlConn.addRequestProperty("Content-Type", "multipart/form-data");
                //设置Authentication头部：添加有效的activiti用户认证信息 【用户<kermit>:密码<kermit>】
                String userNamePassWord = "kermit:kermit";
                String author = (new BASE64Encoder()).encode(userNamePassWord.getBytes());
                urlConn.addRequestProperty("Authorization", "Basic " + author);

                if (urlConn.getResponseCode() == 200) {
                    InputStreamReader isr = new InputStreamReader(
                            urlConn.getInputStream(), "UTF-8");
                    int i;
                    while ((i = isr.read()) != -1) {
                        sResult = sResult + (char) i;
                    }
                    //log.info("\nsResult:"+sResult);
                    System.out.println("sResult:"+sResult);
                    isr.close();
                }
                return sResult;
            }
            //3,DELETE 删除现存资源。
            if ("DELETE".equals(type)) {
                urlConn.setRequestMethod("DELETE");
                urlConn.setDoInput(true);
                urlConn.setDoOutput(true);
                urlConn.setUseCaches(false);
                urlConn.addRequestProperty("Content-Type", "application/json");
                //设置Authentication头部：添加有效的activiti用户认证信息 【用户<kermit>:密码<kermit>】
                String userNamePassWord = "kermit:kermit";
                String author = (new BASE64Encoder()).encode(userNamePassWord.getBytes());
                urlConn.addRequestProperty("Authorization", "Basic " + author);

                if (urlConn.getResponseCode() == 200) {
                    InputStreamReader isr = new InputStreamReader(
                            urlConn.getInputStream(), "UTF-8");
                    int i;
                    while ((i = isr.read()) != -1) {
                        sResult = sResult + (char) i;
                    }
                    // log.info("\nsResult:"+sResult);
                    System.out.println("sResult:"+sResult);
                    isr.close();
                }
                return sResult;
            }

            //4,PUT 更新已有资源的属性。也用来调用现存资源的功能。
            if ("PUT".equals(type)) {
                urlConn.setRequestMethod("PUT");
                urlConn.setDoInput(true);
                urlConn.setDoOutput(true);
                urlConn.setUseCaches(false);
                urlConn.addRequestProperty("Content-Type", "multipart/form-data");
                //设置Authentication头部：添加有效的activiti用户认证信息 【用户<kermit>:密码<kermit>】
                String userNamePassWord = "kermit:kermit";
                String author = (new BASE64Encoder()).encode(userNamePassWord.getBytes());
                urlConn.addRequestProperty("Authorization", "Basic " + author);
                //200 操作成功，响应返回（GET和PUT请求）。
                if (urlConn.getResponseCode() == 200) {
                    InputStreamReader isr = new InputStreamReader(
                            urlConn.getInputStream(), "UTF-8");
                    int i;
                    while ((i = isr.read()) != -1) {
                        sResult = sResult + (char) i;
                    }
                    //log.info("\nsResult:"+sResult);
                    System.out.println("sResult:"+sResult);
                    isr.close();
                }
                return sResult;
            }

        } catch (Exception e) {
            throw e;
        }
        return null;
    }
    /**
     * Rest方式访问
     *
     * @param type 1,GET 获得一个资源或获得多个资源
     *             2,POST 创建一个新资源。当请求结果太复杂，无法放到GET请求的URL中，也用来查询资源。
     *             3,PUT 更新已有资源的属性。也用来调用现存资源的功能。
     *             4,DELETE 删除现存资源。
     * @return
     * @throws Exception
     */
    public String getResponseForURLConnectionParam(String type, String inUrl,String praram) throws Exception {
        String sResult = "";
        try {
            HttpURLConnection urlConn = null;
            String url = serviceUrl + inUrl;
            URL httpUrl = new URL(url);
            urlConn = (HttpURLConnection) httpUrl.openConnection();
            urlConn.setConnectTimeout(20000);
            String rsp = null;

            /**
             * 1,GET 获得一个资源或获得多个资源
             * 2,POST 创建一个新资源。当请求结果太复杂，无法放到GET请求的URL中，也用来查询资源。
             * 3,PUT 更新已有资源的属性。也用来调用现存资源的功能。
             * 4,DELETE 删除现存资源。
             */
            //1,GET 获得一个资源或获得多个资源
            if ("GET".equals(type)) {
                urlConn.setRequestMethod(type);
                urlConn.addRequestProperty("Content-Type", "application/json");
                //设置Authentication头部：添加有效的activiti用户认证信息 【用户<kermit>:密码<kermit>】
                String userNamePassWord = "kermit:kermit";
                String author = (new BASE64Encoder()).encode(userNamePassWord.getBytes());
                urlConn.addRequestProperty("Authorization", "Basic " + author);
                //200操作成功，响应返回（GET和PUT请求）。
                if (urlConn.getResponseCode() == 200) {
                    InputStreamReader isr = new InputStreamReader(
                            urlConn.getInputStream(), "UTF-8");
                    int i;
                    while ((i = isr.read()) != -1) {
                        sResult = sResult + (char) i;
                    }
                    System.out.println("\nsResult:"+sResult);
                    isr.close();
                }
                return sResult;
            }
            //2,POST 创建一个新资源。当请求结果太复杂，无法放到GET请求的URL中，也用来查询资源。
            if ("POST".equals(type)) {
                urlConn.setRequestMethod("POST");
                urlConn.setDoInput(true);
                urlConn.setDoOutput(true);
                urlConn.setUseCaches(false);
                urlConn.addRequestProperty("Content-Type", "multipart/form-data");
                //设置Authentication头部：添加有效的activiti用户认证信息 【用户<kermit>:密码<kermit>】
                String userNamePassWord = "kermit:kermit";
                String author = (new BASE64Encoder()).encode(userNamePassWord.getBytes());
                urlConn.addRequestProperty("Authorization", "Basic " + author);

                if (urlConn.getResponseCode() == 200) {
                    InputStreamReader isr = new InputStreamReader(
                            urlConn.getInputStream(), "UTF-8");
                    int i;
                    while ((i = isr.read()) != -1) {
                        sResult = sResult + (char) i;
                    }
                    //log.info("\nsResult:"+sResult);
                    System.out.println("sResult:"+sResult);
                    isr.close();
                }
                return sResult;
            }
            //3,DELETE 删除现存资源。
            if ("DELETE".equals(type)) {
                urlConn.setRequestMethod("DELETE");
                urlConn.setDoInput(true);
                urlConn.setDoOutput(true);
                urlConn.setUseCaches(false);
                urlConn.addRequestProperty("Content-Type", "application/json");
                //设置Authentication头部：添加有效的activiti用户认证信息 【用户<kermit>:密码<kermit>】
                String userNamePassWord = "kermit:kermit";
                String author = (new BASE64Encoder()).encode(userNamePassWord.getBytes());
                urlConn.addRequestProperty("Authorization", "Basic " + author);

                if (urlConn.getResponseCode() == 200) {
                    InputStreamReader isr = new InputStreamReader(
                            urlConn.getInputStream(), "UTF-8");
                    int i;
                    while ((i = isr.read()) != -1) {
                        sResult = sResult + (char) i;
                    }
                    // log.info("\nsResult:"+sResult);
                    System.out.println("sResult:"+sResult);
                    isr.close();
                }
                return sResult;
            }

            //4,PUT 更新已有资源的属性。也用来调用现存资源的功能。
            if ("PUT".equals(type)) {
                urlConn.setRequestMethod("PUT");
                urlConn.setDoInput(true);
                urlConn.setDoOutput(true);
                urlConn.setUseCaches(false);
                urlConn.addRequestProperty("Content-Type", "multipart/form-data");
                //设置Authentication头部：添加有效的activiti用户认证信息 【用户<kermit>:密码<kermit>】
                String userNamePassWord = "kermit:kermit";
                String author = (new BASE64Encoder()).encode(userNamePassWord.getBytes());
                urlConn.addRequestProperty("Authorization", "Basic " + author);


                OutputStream out = urlConn.getOutputStream();
                OutputStreamWriter writer = new OutputStreamWriter(out, "UTF-8");
                writer.write(praram);
                writer.flush();
                writer.close();
                out.close();
                //200 操作成功，响应返回（GET和PUT请求）。
                if (urlConn.getResponseCode() == 200) {
                    InputStreamReader isr = new InputStreamReader(
                            urlConn.getInputStream(), "UTF-8");
                    int i;
                    while ((i = isr.read()) != -1) {
                        sResult = sResult + (char) i;
                    }
                    //log.info("\nsResult:"+sResult);
                    System.out.println("sResult:"+sResult);
                    isr.close();
                }
                return sResult;
            }

        } catch (Exception e) {
            throw e;
        }
        return null;
    }

    /**
     * Rest 访问
     *
     * @param url     访问的
     * @param type    1,GET 获得一个资源或获得多个资源
     *                2,POST 创建一个新资源。当请求结果太复杂，无法放到GET请求的URL中，也用来查询资源。
     *                3,PUT 更新已有资源的属性。也用来调用现存资源的功能。
     *                4,DELETE 删除现存资源。
     * @param postStr 传递参数
     * @return sResult  String返回响应结果
     */
    public String getResponseForJsonURLConnection(String url, String type, String postStr) {
        //String url1 = serviceUrl+"/runtime/process-instances";
        String url1 = serviceUrl + url;
        String sResult = "";
        try {
            HttpURLConnection urlConn = null;
            URL httpUrl = new URL(url1);
            urlConn = (HttpURLConnection) httpUrl.openConnection();
            urlConn.setConnectTimeout(20000);

            urlConn.setRequestMethod("POST");

            urlConn.setDoInput(true);
            urlConn.setDoOutput(true);
            urlConn.setUseCaches(false);
            urlConn.addRequestProperty("Content-Type", "application/json");

            //设置Authentication头部：添加有效的activiti用户认证信息 【用户<kermit>:密码<kermit>】
            String userNamePassWord = "kermit:kermit";
            String author = (new BASE64Encoder()).encode(userNamePassWord.getBytes());
            urlConn.addRequestProperty("Authorization", "Basic " + author);

            OutputStream out = urlConn.getOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter(out, "UTF-8");
            writer.write(postStr);
            writer.flush();
            writer.close();
            out.close();
            //200 操作成功，响应返回（GET和PUT请求）。
            if (urlConn.getResponseCode() == 200) {
                InputStreamReader isr = new InputStreamReader(
                        urlConn.getInputStream(), "UTF-8");
                int i;
                while ((i = isr.read()) != -1) {
                    sResult = sResult + (char) i;
                }
                isr.close();
            }
            //201 操作成功，实体已创建，并返回到响应体中（POST请求）。
            if (urlConn.getResponseCode() == 201) {
                InputStreamReader isr = new InputStreamReader(
                        urlConn.getInputStream(), "UTF-8");
                int i;
                while ((i = isr.read()) != -1) {
                    sResult = sResult + (char) i;
                }
                isr.close();
            }
            // log.info("\nsResult:"+sResult);
            System.out.println("sResult:"+sResult);
            return sResult;
        } catch (Exception e) {
        }
        return null;
    }
}
