package com.jumipm.workflow;

import java.util.List;
import java.util.Map;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jumipm.workflow.impl.FlowElement;
import com.jumipm.workflow.impl.ModelInfo;
import com.jumipm.workflow.impl.TaskInfo;


/**
 * 流程引擎
 * 在使用activiti的时候需要1、加入oracle驱动、2修改db.property文件、3在activiti-custom-context.xml的engine配置中增加<property name="databaseSchema" value="XJLFLOW"/><br>
 * 流程图中看到的字体是乱码，修改了流程发布字符集，参考activiti自建工程包org.activiti.editor.ui.EditorProcessDefinitionDetailPanel
 * @author bingjun.song@jumipm.com
 *
 */

public interface ProcessEngine {
	/**
	 * 得到所有的发布流程
	 * @return
	 */
	public String getDeployments();
	/**
	 * 得到一个发布流程的信息
	 * @param deployId
	 * @return
	 */
	public String getDeployment(String deployId);

	/**
	 * 获取所有已部署的流程定义
	 * 
	 * @return
	 */
	public String getProcessDefinitions();
	
	
	/**
	 * 获取流程图Url
	 * 
	 * @param processKey 流程定义key
	 * @return
	 */
	public String getProcessGraphUrl(String processKey);
	
	public String getProcessTrackGraphUrl(String businessKey);

	/**
	 * 得到流程定义
	 * @param processDefinitionId 流程id
	 * @return
	 */
	public String getProcessDefinitionById(String processDefinitionId);
	/**
	 * 得到流程定义
	 * @param processDefinitionKey 流程Key
	 * @return
	 */
	public String getProcessDefinitionByKey(String processDefinitionKey);
	
	/**
	 * 得到一个流程图
	 * @param processDefinitionId
	 * @return
	 */
	public byte[] getProcessDefinitionImage(String processDefinitionId);
	
	/**
	 * 得到流程定义ID
	 * @param processKey
	 * @return
	 */
	public String getProcessDefinetionId(String processKey);
	/**
	 * 得到一个流程图 根据流程key(流程名称)
	 * @param processKey
	 * @return
	 */
	public byte[] getProcessDefinitionImageByKey(String processKey);
	
	
	/**
	 * 获取流程实例图Url
	 * @param processInstanceId
	 * @return
	 */
	public String getActivitiProcessTrackByProcessInstanceId(String processInstanceId);
	/**
	 * 启动一个业务流程
	 * 
	 * @param processDefinitionId  流程定义ID
	 * @param businessKey 业务Key
	 * @param variables 启动流程实例变量
	 * @return 流程实例ID
	 */
	public String startProcessById(String processDefinitionId, String businessKey,JSONArray variables);
	/**
	 * 启动一个业务流程
	 * @param processDefinitionKey 流程定义Key
	 * @param businessKey
	 * @param variables 启动流程实例变量
	 * 	@return 流程实例ID
	 */
	public String startProcessByKey(String processDefinitionKey, String businessKey,JSONArray variables);
	
	/**
	 * 指定启动提交
	 * 
	 * @param processDefinitionKey 流程定义key
	 * @param businessKey          业务主键
	 * @param assigneeOrRole       代办角色
	 * @param owner                任务拥有者
	 * @param description
	 * @param variables
	 */
	public void appointStartProcessByKey(String processDefinitionKey, String businessKey,String assigneeOrRole,String owner,String description,JSONArray variables);
	/**
	 * 启动一个业务流程
	 * @param processDefinitionId 流程定义id
	 * @param businessKey
	 * @param variables 启动流程实例变量
	 * 	@return 流程实例ID
	 */
	public String startProcessByDefinitionId(String processDefinitionId, String businessKey,JSONArray variables);
	/**
	 * 指定启动提交
	 * 
	 * @param processDefinitionId 流程定义id
	 * @param businessKey          业务主键
	 * @param assigneeOrRole       代办角色
	 * @param owner                任务拥有者
	 * @param description
	 * @param variables
	 */
	public void appointStartProcessByDefinitionId(String processDefinitionId, String businessKey,String assigneeOrRole,String owner,String description,JSONArray variables);
	/**
	 * 得到所有待办任务
	 * @param userId 用户id
	 * @return
	 */
	public List<TaskInfo> getMyTask(String userId);
	
	/**
	 * 获取审批历史任务列表
	 * @param bussinessKey
	 * @return
	 */
	public List<TaskInfo> getMyHistoryTask(String bussinessKey);
	
	/**
	 * 获取任务信息
	 * @param taskId
	 * @return
	 */
	public TaskInfo getTaskByTaskId(String taskId);
	
	/**
	 * 得到所有待办任务bussikey
	 * @param userId 用户id
	 * @return
	 */
	public List<String> getTodoBusinessKeyByAssignee(String userId);
	
	/**
	 * 得到所有待办任务bussikey
	 * @param taskAssignee 用户id
	 * @return
	 */
	public List<String> getDoneBusinessKeyByAssignee(String taskAssignee);
	  /**
     * 通过实例ID获取流程实例
     * 参数：processInstanceId 流程实例ID
     *
     * @throws Exception
     */
    
    public JSONObject getJsonObjProcessInstanceById(String processInstanceId);
	/**
	 * 得到待办任务列表
	 * @param userId 用户id
	 * @param processDefinitionKey 流程key
	 * @return
	 */
	public List<TaskInfo> getMyTask(String userId, String processDefinitionKey);
	/**
	 * 可以认领的任务
	 * @param userId
	 * @return
	 */
public List getCandidaTask(String userId);
	/**
	 * 得到所有组的任务，还没有分配给我，但是我可以认领的
	 * 
	 * @return
	 */
	public List getGroupTask(String userId);
	/**
	 * 认领任务
	 */
	public void claimTask(String taskId, String userId);

	/**
	 * 执行任务
	 * 
	 * @param taskId
	 */
	public void completeTask(String taskId, JSONArray variables);
	
	/**
	 * 更新task
	 * 
	 * @param taskId
	 * @param description 任务描述 此处记录审批意见
	 * @param owner       任
	 * 务拥有者
	 */
	public void updateTask(String taskId,String description,String owner);
	
	
	/**
	 * 执行审批任务 通过业务主键 businessKey
	 * 
	 * @param businessKey
	 * @param assigneeOrRole
	 */
	/**
	 * @param businessKey
	 * @param assigneeOrRole
	 * @return 0-未到最后节点 1-到最后节点
	 */
	public int appointCompleteTask(String businessKey,String assigneeOrRole,String owner,String description,JSONArray variables);
	
	/**
	 * 通过businessKey 获取运行的taskId
	 * 
	 * @param businessKey
	 * @return
	 */
	public TaskInfo getTaskByBusinessKey(String businessKey);
	
	/**
	 * 得到我参与过的任务
	 * @param userId
	 * @return
	 */
	public List getHistoryTask(String userId);
	/**
	 * 增加一个用户到realNameGroup
	 * 
	 */
	public void addUser(String id, String firstName, String lastName, String email,String password);
	public void addUserToGroup(String userId, String groupId);
	
	
	/**
	 * 获取流程包含的流程节点信息
	 * @param processDefinitionId
	 */
	public List<FlowElement> getFlowElementsByDefinitionId(String processDefinitionId);
	
	/**
	 * 获取模型列表
	 * @param start  显示的起始页数
	 * @param  size  每页显示的最大数目
	 * return list 返回列表
	 */
	public Map<String, Object> getModels(int start,int size);
	/**
	 * 根据ID 删除模型
	 * @param ModelId  要删除的modelid
	 * @param  size  每页显示的最大数目
	 * return Map  key=total时为记录总数，key=list为根据条件查询数据列表
	 */
	public void deleteModel(String modelId);
	/**
	 * 通过部署id判断是否有待处理任务
	 * 
	 */
	public int isHaveTasksByDeploymentId(String deploymentId); 
}
